/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.subscriber.impl.delegate;

import com.epam.ta.reportportal.core.events.ProjectIdAwareEvent;
import com.epam.ta.reportportal.core.events.handler.ConfigurableEventHandler;
import com.epam.ta.reportportal.core.events.subscriber.EventSubscriber;
import com.epam.ta.reportportal.core.project.config.ProjectConfigProvider;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConfigDelegatingSubscriber<T extends ProjectIdAwareEvent>
implements EventSubscriber<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectConfigDelegatingSubscriber.class);
    private final ProjectConfigProvider projectConfigProvider;
    private final List<ConfigurableEventHandler<T, Map<String, String>>> eventHandlers;

    public ProjectConfigDelegatingSubscriber(ProjectConfigProvider projectConfigProvider, List<ConfigurableEventHandler<T, Map<String, String>>> eventHandlers) {
        this.projectConfigProvider = projectConfigProvider;
        this.eventHandlers = eventHandlers;
    }

    @Override
    public void handleEvent(T event) {
        Map<String, String> projectConfig = this.projectConfigProvider.provide(event.getProjectId());
        this.eventHandlers.forEach(h -> {
            try {
                h.handle(event, projectConfig);
            }
            catch (Exception e) {
                LOGGER.debug("Error while processing event: " + e.getMessage());
            }
        });
    }
}

