/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.launch;

import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.pattern.service.LaunchPatternAnalyzer;
import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.ConfigurableEventHandler;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.google.common.collect.Sets;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LaunchPatternAnalysisRunner
implements ConfigurableEventHandler<LaunchFinishedEvent, Map<String, String>> {
    private final GetLaunchHandler getLaunchHandler;
    private final LaunchPatternAnalyzer launchPatternAnalyzer;

    @Autowired
    public LaunchPatternAnalysisRunner(GetLaunchHandler getLaunchHandler, LaunchPatternAnalyzer launchPatternAnalyzer) {
        this.getLaunchHandler = getLaunchHandler;
        this.launchPatternAnalyzer = launchPatternAnalyzer;
    }

    @Override
    @Transactional
    public void handle(LaunchFinishedEvent launchFinishedEvent, Map<String, String> projectConfig) {
        boolean isPatternAnalysisEnabled = BooleanUtils.toBoolean((String)projectConfig.get(ProjectAttributeEnum.AUTO_PATTERN_ANALYZER_ENABLED.getAttribute()));
        if (isPatternAnalysisEnabled) {
            Launch launch = this.getLaunchHandler.get(launchFinishedEvent.getId());
            this.launchPatternAnalyzer.analyzeLaunch(launch, Sets.newHashSet((Object[])new AnalyzeItemsMode[]{AnalyzeItemsMode.TO_INVESTIGATE, AnalyzeItemsMode.IGNORE_IMMEDIATE}));
        }
    }
}

