/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.item;

import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.ta.reportportal.core.analyzer.auto.AnalyzerService;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.activity.item.TestItemFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.ConfigurableEventHandler;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class TestItemAutoAnalysisRunner
implements ConfigurableEventHandler<TestItemFinishedEvent, Map<String, String>> {
    protected static final String IMMEDIATE_AUTO_ANALYSIS = "immediateAutoAnalysis";
    private final AnalyzerService analyzerService;
    private final LogIndexer logIndexer;
    private final GetLaunchHandler getLaunchHandler;

    public TestItemAutoAnalysisRunner(AnalyzerService analyzerService, LogIndexer logIndexer, GetLaunchHandler getLaunchHandler) {
        this.analyzerService = analyzerService;
        this.logIndexer = logIndexer;
        this.getLaunchHandler = getLaunchHandler;
    }

    @Override
    public void handle(TestItemFinishedEvent testItemFinishedEvent, Map<String, String> projectConfig) {
        if (this.analyzerService.hasAnalyzers() && this.isNeedToRunAA(testItemFinishedEvent.getTestItem())) {
            AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(projectConfig);
            TestItem testItem = testItemFinishedEvent.getTestItem();
            this.logIndex(testItem, testItemFinishedEvent.getProjectId(), analyzerConfig);
            Launch launch = this.getLaunchHandler.get(testItem.getLaunchId());
            this.analyzerService.runAnalyzers(launch, List.of(testItem.getItemId()), analyzerConfig);
            this.logIndex(testItem, testItemFinishedEvent.getProjectId(), analyzerConfig);
        }
    }

    private void logIndex(TestItem testItem, Long projectId, AnalyzerConfig config) {
        this.logIndexer.indexItemsLogs(projectId, testItem.getLaunchId(), List.of(testItem.getItemId()), config);
    }

    private boolean isNeedToRunAA(TestItem testItem) {
        if (Objects.nonNull(testItem.getItemResults().getIssue()) && testItem.getItemResults().getIssue().getIssueType().getIssueGroup().getTestItemIssueGroup().equals((Object)TestItemIssueGroup.TO_INVESTIGATE)) {
            return testItem.getAttributes().stream().filter(at -> at.getTestItem().getItemResults().getIssue().getIgnoreAnalyzer() == false).anyMatch(at -> IMMEDIATE_AUTO_ANALYSIS.equals(at.getKey()) && Boolean.parseBoolean(at.getValue()) && at.isSystem() != false);
        }
        return false;
    }
}

