/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.activity.DefectTypeDeletedEvent;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.google.common.cache.Cache;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
@Transactional
public class DefectTypeDeletedHandler {
    private final AnalyzerStatusCache analyzerStatusCache;
    private final AnalyzerServiceClient analyzerServiceClient;
    private final LaunchRepository launchRepository;
    private final LogIndexer logIndexer;
    private final ProjectRepository projectRepository;

    @Autowired
    public DefectTypeDeletedHandler(AnalyzerStatusCache analyzerStatusCache, AnalyzerServiceClient analyzerServiceClient, LaunchRepository launchRepository, LogIndexer logIndexer, ProjectRepository projectRepository) {
        this.analyzerStatusCache = analyzerStatusCache;
        this.analyzerServiceClient = analyzerServiceClient;
        this.launchRepository = launchRepository;
        this.logIndexer = logIndexer;
        this.projectRepository = projectRepository;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Retryable(retryFor={ReportPortalException.class}, maxAttempts=5, backoff=@Backoff(value=5000L))
    @TransactionalEventListener
    public void handleDefectTypeDeleted(DefectTypeDeletedEvent event) {
        Project project = (Project)this.projectRepository.findById((Object)event.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{event.getProjectId()}));
        if (this.analyzerServiceClient.hasClients()) {
            Cache<Long, Long> analyzeStatus = this.analyzerStatusCache.getAnalyzeStatus("autoAnalyzer").orElseThrow(() -> new ReportPortalException(ErrorType.ANALYZER_NOT_FOUND, new Object[]{"autoAnalyzer"}));
            BusinessRule.expect((Object)analyzeStatus.asMap().containsValue(event.getProjectId()), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until auto-analysis proceeds."});
            this.logIndexer.index(event.getProjectId(), AnalyzerUtils.getAnalyzerConfig(project));
        }
    }
}

