/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.reportportal.model.externalsystem.Ticket;
import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.model.activity.TestItemActivityResource;
import com.google.common.base.Strings;

public class TicketPostedEvent
extends AbstractEvent
implements ActivityEvent {
    private Ticket ticket;
    private TestItemActivityResource testItemActivityResource;

    public TicketPostedEvent() {
    }

    public TicketPostedEvent(Ticket ticket, Long userId, String userLogin, TestItemActivityResource testItemActivityResource) {
        super(userId, userLogin);
        this.ticket = ticket;
        this.testItemActivityResource = testItemActivityResource;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public TestItemActivityResource getTestItemActivityResource() {
        return this.testItemActivityResource;
    }

    public void setTestItemActivityResource(TestItemActivityResource testItemActivityResource) {
        this.testItemActivityResource = testItemActivityResource;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.POST).addEventName(ActivityAction.POST_ISSUE.getValue()).addPriority(EventPriority.LOW).addObjectId(this.testItemActivityResource.getId()).addObjectName(this.testItemActivityResource.getName()).addObjectType(EventObject.ITEM_ISSUE).addProjectId(this.testItemActivityResource.getProjectId()).addSubjectId(this.getUserId()).addSubjectName(this.getUserLogin()).addSubjectType(EventSubject.USER).addHistoryField("ticketId", Strings.isNullOrEmpty((String)this.testItemActivityResource.getTickets()) ? "" : this.testItemActivityResource.getTickets(), Strings.isNullOrEmpty((String)this.testItemActivityResource.getTickets()) ? this.ticket.getId() + ":" + this.ticket.getTicketUrl() : this.testItemActivityResource.getTickets() + "," + this.ticket.getId() + ":" + this.ticket.getTicketUrl()).get();
    }
}

