/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class ProjectBulkDeletedEvent
extends AbstractEvent
implements ActivityEvent {
    private static final String COMMA_SEPARATOR = ",";
    private final Collection<String> projectNames;

    public ProjectBulkDeletedEvent(Long userId, String userLogin, Collection<String> projectNames) {
        super(userId, userLogin);
        this.projectNames = projectNames;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.BULK_DELETE).addEventName(ActivityAction.BULK_DELETE_PROJECT.getValue()).addPriority(EventPriority.CRITICAL).addObjectName(StringUtils.join(this.projectNames, (String)COMMA_SEPARATOR)).addObjectType(EventObject.PROJECT).addSubjectId(this.getUserId()).addSubjectName(this.getUserLogin()).addSubjectType(EventSubject.USER).get();
    }
}

