/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AroundEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.model.activity.TestItemActivityResource;
import com.google.common.base.Strings;

public class LinkTicketEvent
extends AroundEvent<TestItemActivityResource>
implements ActivityEvent {
    private boolean isLinkedByAnalyzer;

    public LinkTicketEvent() {
    }

    public LinkTicketEvent(TestItemActivityResource before, TestItemActivityResource after, Long userId, String userLogin, boolean isLinkedByAnalyzer) {
        super(userId, userLogin, before, after);
        this.isLinkedByAnalyzer = isLinkedByAnalyzer;
    }

    public LinkTicketEvent(TestItemActivityResource before, TestItemActivityResource after, String userLogin, boolean isLinkedByAnalyzer) {
        super(null, userLogin, before, after);
        this.isLinkedByAnalyzer = isLinkedByAnalyzer;
    }

    public boolean isLinkedByAnalyzer() {
        return this.isLinkedByAnalyzer;
    }

    public void setLinkedByAnalyzer(boolean linkedByAnalyzer) {
        this.isLinkedByAnalyzer = linkedByAnalyzer;
    }

    @Override
    public Activity toActivity() {
        ActivityBuilder builder = new ActivityBuilder().addCreatedNow().addAction(EventAction.LINK).addEventName(this.isLinkedByAnalyzer ? ActivityAction.LINK_ISSUE_AA.getValue() : ActivityAction.LINK_ISSUE.getValue()).addPriority(EventPriority.LOW).addObjectId(((TestItemActivityResource)this.getAfter()).getId()).addObjectName(((TestItemActivityResource)this.getAfter()).getName()).addObjectType(EventObject.ITEM_ISSUE).addProjectId(((TestItemActivityResource)this.getAfter()).getProjectId()).addSubjectId(this.isLinkedByAnalyzer ? null : this.getUserId()).addSubjectName(this.isLinkedByAnalyzer ? "analyzer" : this.getUserLogin()).addSubjectType(this.isLinkedByAnalyzer ? EventSubject.APPLICATION : EventSubject.USER);
        if (this.getAfter() != null) {
            String oldValue = ((TestItemActivityResource)this.getBefore()).getTickets();
            String newValue = ((TestItemActivityResource)this.getAfter()).getTickets();
            if (Strings.isNullOrEmpty((String)oldValue) && newValue.isEmpty() || oldValue.equalsIgnoreCase(newValue)) {
                return null;
            }
            if (!oldValue.isEmpty() && !newValue.isEmpty() || !oldValue.equalsIgnoreCase(newValue)) {
                if (oldValue.length() > newValue.length()) {
                    builder.addAction(EventAction.UNLINK);
                    builder.addEventName(ActivityAction.UNLINK_ISSUE.getValue());
                }
                builder.addHistoryField("ticketId", oldValue, newValue);
            }
        }
        return builder.get();
    }
}

