/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.ProjectIdAwareEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.launch.Launch;

public class LaunchFinishedEvent
extends AbstractEvent
implements ActivityEvent,
ProjectIdAwareEvent {
    private Long id;
    private String name;
    private LaunchModeEnum mode;
    private Long projectId;
    private ReportPortalUser user;
    private String baseUrl;
    private final boolean isSystemEvent;

    public LaunchFinishedEvent(Launch launch) {
        this(launch, null, null, true);
        this.id = launch.getId();
        this.name = launch.getName();
        this.mode = launch.getMode();
        this.projectId = launch.getProjectId();
    }

    public LaunchFinishedEvent(Launch launch, Long userId, String userLogin, boolean isSystemEvent) {
        super(userId, userLogin);
        this.id = launch.getId();
        this.name = launch.getName();
        this.mode = launch.getMode();
        this.projectId = launch.getProjectId();
        this.isSystemEvent = isSystemEvent;
    }

    public LaunchFinishedEvent(Launch launch, Long userId, String userLogin, String baseUrl) {
        this(launch, userId, userLogin, false);
        this.baseUrl = baseUrl;
    }

    public LaunchFinishedEvent(Launch launch, ReportPortalUser user, String baseUrl) {
        this(launch, user.getUserId(), user.getUsername(), false);
        this.user = user;
        this.baseUrl = baseUrl;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LaunchModeEnum getMode() {
        return this.mode;
    }

    public void setMode(LaunchModeEnum mode) {
        this.mode = mode;
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ReportPortalUser getUser() {
        return this.user;
    }

    public void setUser(ReportPortalUser user) {
        this.user = user;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.FINISH).addEventName(ActivityAction.FINISH_LAUNCH.getValue()).addPriority(EventPriority.LOW).addObjectId(this.id).addObjectName(this.name).addObjectType(EventObject.LAUNCH).addProjectId(this.projectId).addSubjectId(this.isSystemEvent ? null : this.getUserId()).addSubjectName(this.isSystemEvent ? "ReportPortal" : this.getUserLogin()).addSubjectType(this.isSystemEvent ? EventSubject.APPLICATION : EventSubject.USER).get();
    }
}

