/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.entity.user.UserRole;

public class ChangeUserTypeEvent
extends AbstractEvent
implements ActivityEvent {
    private Long userId;
    private String userName;
    private UserRole oldType;
    private UserRole newType;

    public ChangeUserTypeEvent() {
    }

    public ChangeUserTypeEvent(Long userId, String userName, UserRole oldRole, UserRole newRole, Long editorId, String editorUsername) {
        super(editorId, editorUsername);
        this.userId = userId;
        this.userName = userName;
        this.oldType = oldRole;
        this.newType = newRole;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.UPDATE_USER_ROLE).addEventName(EventAction.UPDATE_USER_ROLE.getValue()).addPriority(UserRole.ADMINISTRATOR.equals((Object)this.newType) ? EventPriority.CRITICAL : EventPriority.HIGH).addObjectId(this.userId).addObjectName(this.userName).addObjectType(EventObject.USER).addSubjectId(this.getUserId()).addSubjectName(this.getUserLogin()).addSubjectType(EventSubject.USER).addHistoryField("userRole", this.oldType.getAuthority(), this.newType.getAuthority()).get();
    }
}

