/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events;

import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.entity.activity.Activity;
import java.util.Objects;
import org.springframework.amqp.core.AmqpTemplate;

public class MessageBusImpl
implements MessageBus {
    private final AmqpTemplate amqpTemplate;

    public MessageBusImpl(AmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
    }

    @Override
    public void publish(String exchange, String route, Object o) {
        this.amqpTemplate.convertAndSend(exchange, route, o);
    }

    @Override
    public void publish(String route, Object o) {
        this.amqpTemplate.convertAndSend(route, o);
    }

    @Override
    public void publishActivity(ActivityEvent event) {
        Activity activity = event.toActivity();
        if (Objects.nonNull(activity)) {
            this.amqpTemplate.convertAndSend("activity", this.generateKey(activity), (Object)activity);
        }
    }

    private String generateKey(Activity activity) {
        return String.format("activity.%d.%s.%s", activity.getProjectId(), activity.getObjectType(), activity.getEventName());
    }
}

