/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.dashboard.GetDashboardHandler;
import com.epam.ta.reportportal.core.widget.WidgetConfigurationService;
import com.epam.ta.reportportal.dao.DashboardRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.model.dashboard.DashboardConfigResource;
import com.epam.ta.reportportal.model.dashboard.DashboardResource;
import com.epam.ta.reportportal.model.widget.WidgetConfigResource;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.DashboardConverter;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetDashboardHandlerImpl
implements GetDashboardHandler {
    private final DashboardRepository dashboardRepository;
    private final WidgetConfigurationService widgetConfigurationService;

    @Override
    public com.epam.ta.reportportal.model.Page<DashboardResource> getDashboards(ReportPortalUser.ProjectDetails projectDetails, Pageable pageable, Filter filter, ReportPortalUser user) {
        Page dashboards = this.dashboardRepository.findByFilter((Queryable)ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable);
        return PagedResourcesAssembler.pageConverter(DashboardConverter.TO_RESOURCE).apply((Page<Dashboard>)dashboards);
    }

    @Override
    public DashboardResource getDashboard(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        Dashboard dashboard = this.getDashboardById(id, projectDetails);
        return DashboardConverter.TO_RESOURCE.apply(dashboard);
    }

    @Override
    public DashboardConfigResource getDashboardConfig(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        Dashboard dashboard = this.getDashboardById(id, projectDetails);
        List<WidgetConfigResource> widgets = this.widgetConfigurationService.getWidgetsConfiguration(dashboard, projectDetails);
        return DashboardConfigResource.builder().widgetsConfig(widgets).build();
    }

    private Dashboard getDashboardById(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        return (Dashboard)this.dashboardRepository.findByIdAndProjectId(id, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.DASHBOARD_NOT_FOUND_IN_PROJECT, new Object[]{id, projectDetails.getProjectName()}));
    }

    @Generated
    public GetDashboardHandlerImpl(DashboardRepository dashboardRepository, WidgetConfigurationService widgetConfigurationService) {
        this.dashboardRepository = dashboardRepository;
        this.widgetConfigurationService = widgetConfigurationService;
    }
}

