/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.dashboard.DeleteDashboardHandler;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.DashboardDeletedEvent;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.dao.DashboardRepository;
import com.epam.ta.reportportal.dao.DashboardWidgetRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.entity.dashboard.DashboardWidget;
import com.epam.ta.reportportal.ws.converter.converters.DashboardConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DeleteDashboardHandlerImpl
implements DeleteDashboardHandler {
    private final DashboardRepository dashboardRepository;
    private final DashboardWidgetRepository dashboardWidgetRepository;
    private final WidgetRepository widgetRepository;
    private final WidgetContentRemover widgetContentRemover;
    private final MessageBus messageBus;

    @Autowired
    public DeleteDashboardHandlerImpl(DashboardRepository dashboardRepository, DashboardWidgetRepository dashboardWidgetRepository, WidgetRepository widgetRepository, @Qualifier(value="delegatingStateContentRemover") WidgetContentRemover widgetContentRemover, MessageBus messageBus) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardWidgetRepository = dashboardWidgetRepository;
        this.widgetRepository = widgetRepository;
        this.widgetContentRemover = widgetContentRemover;
        this.messageBus = messageBus;
    }

    @Override
    public OperationCompletionRS deleteDashboard(Long dashboardId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findByIdAndProjectId(dashboardId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.DASHBOARD_NOT_FOUND_IN_PROJECT, new Object[]{dashboardId, projectDetails.getProjectName()}));
        Set dashboardWidgets = dashboard.getWidgets();
        List widgets = dashboardWidgets.stream().filter(DashboardWidget::isCreatedOn).map(DashboardWidget::getWidget).peek(this.widgetContentRemover::removeContent).collect(Collectors.toList());
        dashboardWidgets.addAll(widgets.stream().flatMap(w -> w.getDashboardWidgets().stream()).collect(Collectors.toSet()));
        this.dashboardWidgetRepository.deleteAll((Iterable)dashboardWidgets);
        this.dashboardRepository.delete((Object)dashboard);
        this.widgetRepository.deleteAll(widgets);
        this.messageBus.publishActivity(new DashboardDeletedEvent(DashboardConverter.TO_ACTIVITY_RESOURCE.apply(dashboard), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Dashboard with ID = '" + dashboardId + "' successfully deleted.");
    }
}

