/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.dashboard.CreateDashboardHandler;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.DashboardCreatedEvent;
import com.epam.ta.reportportal.dao.DashboardRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.dashboard.CreateDashboardRQ;
import com.epam.ta.reportportal.ws.converter.builders.DashboardBuilder;
import com.epam.ta.reportportal.ws.converter.converters.DashboardConverter;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Service;

@Service
public class CreateDashboardHandlerImpl
implements CreateDashboardHandler {
    private static final int DASHBOARD_LIMIT = 3000;
    private final DashboardRepository dashboardRepository;
    private final MessageBus messageBus;

    @Override
    public EntryCreatedRS createDashboard(ReportPortalUser.ProjectDetails projectDetails, CreateDashboardRQ rq, ReportPortalUser user) {
        BusinessRule.expect((Object)(this.dashboardRepository.findAllByProjectId(projectDetails.getProjectId()).size() >= 3000 ? 1 : 0), BooleanUtils::isFalse).verify(ErrorType.DASHBOARD_UPDATE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"The limit of {} dashboards has been reached. To create a new one you need to delete at least one created previously.", (Object[])new Object[]{3000})});
        BusinessRule.expect((Object)this.dashboardRepository.existsByNameAndProjectId(rq.getName(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{rq.getName()});
        Dashboard dashboard = new DashboardBuilder().addDashboardRq(rq).addProject(projectDetails.getProjectId()).addOwner(user.getUsername()).get();
        this.dashboardRepository.save((Object)dashboard);
        this.messageBus.publishActivity(new DashboardCreatedEvent(DashboardConverter.TO_ACTIVITY_RESOURCE.apply(dashboard), user.getUserId(), user.getUsername()));
        return new EntryCreatedRS(dashboard.getId());
    }

    @Generated
    public CreateDashboardHandlerImpl(DashboardRepository dashboardRepository, MessageBus messageBus) {
        this.dashboardRepository = dashboardRepository;
        this.messageBus = messageBus;
    }
}

