/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.security;

import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;

public class JwtReportPortalUserConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private final UserDetailsService userDetailsService;
    private Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
    private static final String PRINCIPAL_CLAIM_NAME = "user_name";

    public JwtReportPortalUserConverter(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public final AbstractAuthenticationToken convert(Jwt jwt) {
        Collection authorities = (Collection)this.jwtGrantedAuthoritiesConverter.convert((Object)jwt);
        String username = jwt.getClaimAsString(PRINCIPAL_CLAIM_NAME);
        UserDetails principal = this.userDetailsService.loadUserByUsername(username);
        return new UsernamePasswordAuthenticationToken((Object)principal, null, authorities);
    }

    public void setJwtGrantedAuthoritiesConverter(@NotNull Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter) {
        this.jwtGrantedAuthoritiesConverter = jwtGrantedAuthoritiesConverter;
    }
}

