/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.rabbit;

import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.MessageBusImpl;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Base64UrlNamingStrategy;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.NamingStrategy;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={Conditions.NotTestCondition.class})
public class InternalConfiguration {
    public static final String EXCHANGE_EVENTS = "broadcast.events";
    public static final String EXCHANGE_ACTIVITY = "activity";
    public static final String EXCHANGE_ATTACHMENT = "attachment";
    public static final String EXCHANGE_NOTIFICATION = "notification";
    public static final String KEY_EVENTS = "broadcast.events";
    public static final String QUEUE_ACTIVITY = "activity";
    public static final String QUEUE_ACTIVITY_KEY = "activity.#";
    public static final String QUEUE_ATTACHMENT_DELETE = "attachment.delete";
    public static final String QUEUE_EMAIL = "notification.email";
    public static final String QUEUE_QUERY_RQ = "query-rq";

    @Bean
    public MessageBus messageBus(@Autowired @Qualifier(value="rabbitTemplate") AmqpTemplate amqpTemplate) {
        return new MessageBusImpl(amqpTemplate);
    }

    @Bean
    public FanoutExchange eventsExchange() {
        return new FanoutExchange("broadcast.events", false, false);
    }

    @Bean
    public TopicExchange activityExchange() {
        return new TopicExchange("activity", true, false);
    }

    @Bean
    public DirectExchange attachmentExchange() {
        return new DirectExchange(EXCHANGE_ATTACHMENT, true, false);
    }

    @Bean
    public DirectExchange notificationExchange() {
        return new DirectExchange(EXCHANGE_NOTIFICATION, true, false);
    }

    @Bean
    public Queue eventsQueue() {
        return new AnonymousQueue((NamingStrategy)new Base64UrlNamingStrategy("broadcast.events."));
    }

    @Bean
    public Queue activityQueue() {
        return new Queue("activity");
    }

    @Bean
    public Queue deleteAttachmentQueue() {
        return new Queue(QUEUE_ATTACHMENT_DELETE);
    }

    @Bean
    public Queue queryQueue() {
        return new Queue(QUEUE_QUERY_RQ);
    }

    @Bean
    public Queue emailNotificationQueue() {
        return new Queue(QUEUE_EMAIL);
    }

    @Bean
    public Binding eventsQueueBinding() {
        return BindingBuilder.bind((Queue)this.eventsQueue()).to(this.eventsExchange());
    }

    @Bean
    public Binding eventsActivityBinding() {
        return BindingBuilder.bind((Queue)this.activityQueue()).to(this.activityExchange()).with(QUEUE_ACTIVITY_KEY);
    }

    @Bean
    public Binding attachmentDeleteBinding() {
        return BindingBuilder.bind((Queue)this.deleteAttachmentQueue()).to(this.attachmentExchange()).with(QUEUE_ATTACHMENT_DELETE);
    }

    @Bean
    public Binding emailNotificationBinding() {
        return BindingBuilder.bind((Queue)this.emailNotificationQueue()).to(this.notificationExchange()).with(QUEUE_EMAIL);
    }
}

