/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.cluster;

import com.epam.ta.reportportal.core.launch.cluster.CreateClusterHandler;
import com.epam.ta.reportportal.core.launch.cluster.config.GenerateClustersConfig;
import com.epam.ta.reportportal.core.launch.cluster.pipeline.DeleteClustersPartProvider;
import com.epam.ta.reportportal.core.launch.cluster.pipeline.SaveClusterDataPartProvider;
import com.epam.ta.reportportal.core.launch.cluster.pipeline.SaveLastRunAttributePartProvider;
import com.epam.ta.reportportal.core.launch.cluster.pipeline.data.resolver.ClusterDataProviderResolver;
import com.epam.ta.reportportal.dao.ClusterRepository;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.pipeline.PipelineConstructor;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GenerateClusterPipelineConfig {
    private final CreateClusterHandler createClusterHandler;
    private final ClusterDataProviderResolver clusterDataProviderResolver;
    private final ClusterRepository clusterRepository;
    private final LogRepository logRepository;
    private final ItemAttributeRepository itemAttributeRepository;

    @Autowired
    public GenerateClusterPipelineConfig(CreateClusterHandler createClusterHandler, ClusterDataProviderResolver clusterDataProviderResolver, ClusterRepository clusterRepository, LogRepository logRepository, ItemAttributeRepository itemAttributeRepository) {
        this.createClusterHandler = createClusterHandler;
        this.clusterDataProviderResolver = clusterDataProviderResolver;
        this.clusterRepository = clusterRepository;
        this.logRepository = logRepository;
        this.itemAttributeRepository = itemAttributeRepository;
    }

    @Bean
    public PipelineConstructor<GenerateClustersConfig> generateClustersPipelineConstructor() {
        return new PipelineConstructor<GenerateClustersConfig>(List.of(this.deleteClustersPartProvider(), this.saveClusterDataPartProvider(), this.saveLastRunAttributePartProvider()));
    }

    @Bean
    public DeleteClustersPartProvider deleteClustersPartProvider() {
        return new DeleteClustersPartProvider(this.clusterRepository, this.logRepository);
    }

    @Bean
    public SaveClusterDataPartProvider saveClusterDataPartProvider() {
        return new SaveClusterDataPartProvider(this.clusterDataProviderResolver, this.createClusterHandler);
    }

    @Bean
    public SaveLastRunAttributePartProvider saveLastRunAttributePartProvider() {
        return new SaveLastRunAttributePartProvider(this.itemAttributeRepository);
    }
}

