/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.analyzer.auto;

import com.epam.ta.reportportal.core.analyzer.auto.AnalyzerService;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.starter.CollectingAutoAnalysisStarter;
import com.epam.ta.reportportal.core.analyzer.auto.starter.LaunchAutoAnalysisStarter;
import com.epam.ta.reportportal.core.analyzer.auto.starter.decorator.AsyncAutoAnalysisStarter;
import com.epam.ta.reportportal.core.analyzer.auto.starter.decorator.AutoAnalysisEnabledStarter;
import com.epam.ta.reportportal.core.analyzer.auto.starter.decorator.ExistingAnalyzerStarter;
import com.epam.ta.reportportal.core.analyzer.auto.starter.decorator.IndexingAutoAnalysisStarter;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeCollectorFactory;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;

@Configuration
public class LaunchAutoAnalysisConfig {
    private final GetLaunchHandler getLaunchHandler;
    private final AnalyzeCollectorFactory analyzeCollectorFactory;
    private final AnalyzerService analyzerService;
    private final LogIndexer logIndexer;
    private final TaskExecutor autoAnalyzeTaskExecutor;

    @Autowired
    public LaunchAutoAnalysisConfig(GetLaunchHandler getLaunchHandler, AnalyzeCollectorFactory analyzeCollectorFactory, AnalyzerService analyzerService, LogIndexer logIndexer, TaskExecutor autoAnalyzeTaskExecutor) {
        this.getLaunchHandler = getLaunchHandler;
        this.analyzeCollectorFactory = analyzeCollectorFactory;
        this.analyzerService = analyzerService;
        this.logIndexer = logIndexer;
        this.autoAnalyzeTaskExecutor = autoAnalyzeTaskExecutor;
    }

    @Bean
    public LaunchAutoAnalysisStarter manualAnalysisStarter() {
        return new ExistingAnalyzerStarter(this.analyzerService, this.asyncAutoAnalysisStarter());
    }

    @Bean
    public LaunchAutoAnalysisStarter autoAnalysisStarter() {
        return new ExistingAnalyzerStarter(this.analyzerService, this.indexingAutoAnalysisStarter());
    }

    @Bean
    public CollectingAutoAnalysisStarter collectingAutoAnalysisStarter() {
        return new CollectingAutoAnalysisStarter(this.getLaunchHandler, this.analyzeCollectorFactory, this.analyzerService, this.logIndexer);
    }

    @Bean
    public AsyncAutoAnalysisStarter asyncAutoAnalysisStarter() {
        return new AsyncAutoAnalysisStarter(this.autoAnalyzeTaskExecutor, this.collectingAutoAnalysisStarter());
    }

    @Bean
    public AutoAnalysisEnabledStarter autoAnalysisEnabledStarter() {
        return new AutoAnalysisEnabledStarter(this.collectingAutoAnalysisStarter());
    }

    @Bean
    public IndexingAutoAnalysisStarter indexingAutoAnalysisStarter() {
        return new IndexingAutoAnalysisStarter(this.getLaunchHandler, this.logIndexer, this.autoAnalysisEnabledStarter());
    }
}

