/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CriteriaHolder;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterTarget;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.util.SchemaFactory;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.fasterxml.jackson.databind.JavaType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.annotation.AuthenticationPrincipal;

@Configuration
@ComponentScan(basePackages={"com.epam.ta.reportportal.ws.controller"})
public class SpringDocConfiguration {
    private static final Set<String> hiddenParams;
    private static final Map<String, String> ATTRIBUTE_TO_FILTER_PREFIX;
    @Autowired
    private ServletContext servletContext;
    @Value(value="${info.build.version}")
    private String buildVersion;
    @Value(value="${server.servlet.context-path:/api}")
    private String pathValue;

    @Bean
    public OpenAPI openAPI() {
        String securitySchemeName = "bearerAuth";
        return new OpenAPI().info(new Info().title("ReportPortal").description("ReportPortal API documentation").version(this.buildVersion).contact(new Contact().name("Support").email("support@reportportal.io")).license(new License().name("Apache 2.0").url("http://www.apache.org/licenses/LICENSE-2.0"))).addSecurityItem(new SecurityRequirement().addList("bearerAuth")).components(new Components().addSecuritySchemes("bearerAuth", new SecurityScheme().name("bearerAuth").type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT"))).addServersItem(new Server().url(this.getPathValue()));
    }

    @Bean
    public ModelConverter iterableModelConverter() {
        return new ModelConverter(this){

            public Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
                JavaType javaType = Json.mapper().constructType(annotatedType.getType());
                if (javaType != null && Iterable.class.equals((Object)javaType.getRawClass())) {
                    annotatedType = new AnnotatedType().type((Type)javaType.containedType(0)).ctxAnnotations(annotatedType.getCtxAnnotations()).parent(annotatedType.getParent()).schemaProperty(annotatedType.isSchemaProperty()).name(annotatedType.getName()).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).propertyName(annotatedType.getPropertyName()).skipOverride(true);
                    return new ArraySchema().items(this.resolve(annotatedType, context, chain));
                }
                return chain.hasNext() ? chain.next().resolve(annotatedType, context, chain) : null;
            }
        };
    }

    @Bean
    public OpenApiCustomizer sortTagsAlphabetically() {
        return openApi -> {
            List sortedTags = openApi.getTags().stream().sorted(Comparator.comparing(Tag::getName)).collect(Collectors.toList());
            openApi.setTags(sortedTags);
        };
    }

    @Bean
    @Order(value=2)
    public OperationCustomizer sortParametersAlphabetically() {
        return (operation, handlerMethod) -> {
            if (operation.getParameters() != null) {
                operation.setParameters(operation.getParameters().stream().sorted(Comparator.comparing(Parameter::getName)).collect(Collectors.toList()));
            }
            return operation;
        };
    }

    @Bean
    public OperationCustomizer apiSummaryCustomizer() {
        return (operation, handlerMethod) -> {
            if (operation.getSummary() == null || operation.getSummary().isEmpty()) {
                String methodName = handlerMethod.getMethod().getName();
                String summary = this.convertMethodNameToTitle(methodName);
                operation.setSummary(summary);
            }
            return operation;
        };
    }

    private String convertMethodNameToTitle(String methodName) {
        StringBuilder title = new StringBuilder(methodName.replaceAll("([A-Z])", " $1"));
        return title.substring(0, 1).toUpperCase(Locale.ROOT) + title.substring(1).trim();
    }

    @Bean
    @Order(value=1)
    public OperationCustomizer customizeParameters() {
        return (operation, handlerMethod) -> {
            for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
                Class parameterType = parameter.getParameterType();
                if (parameterType == Filter.class) {
                    FilterFor filterClass = (FilterFor)parameter.getParameterAnnotation(FilterFor.class);
                    List<Object> defaultParams = Lists.newArrayList();
                    if (filterClass != null && (filterClass.value() == TestItem.class || filterClass.value() == Launch.class)) {
                        defaultParams = StatisticsHelper.defaultStatisticsFields().map(this::buildFilterParameters).collect(Collectors.toList());
                    }
                    List criteriaList = FilterTarget.findByClass(filterClass.value()).getCriteriaHolders();
                    Set<Parameter> filterParams = criteriaList.stream().filter(ch -> !hiddenParams.contains(ch.getFilterCriteria())).map(this::buildFilterParameters).collect(Collectors.toSet());
                    filterParams.addAll(defaultParams);
                    this.setParameters(operation, filterParams);
                    continue;
                }
                if (parameterType != Pageable.class) continue;
                this.setParameters(operation, this.buildPageParameters());
            }
            return operation;
        };
    }

    private Parameter buildFilterParameters(String parameter) {
        String filterPrefix = ATTRIBUTE_TO_FILTER_PREFIX.getOrDefault(parameter, "filter.eq.");
        return new Parameter().in(ParameterIn.QUERY.toString()).name(filterPrefix + parameter).schema((Schema)new IntegerSchema()).description("Filters by '" + parameter + "'");
    }

    private Parameter buildFilterParameters(CriteriaHolder criteriaHolder) {
        Schema schema = SchemaFactory.createSchemaForType(criteriaHolder.getDataType());
        String parameter = criteriaHolder.getFilterCriteria();
        String filterPrefix = ATTRIBUTE_TO_FILTER_PREFIX.getOrDefault(parameter, "filter.eq.");
        return new Parameter().in(ParameterIn.QUERY.toString()).name(filterPrefix + parameter).schema(schema).description("Filters by '" + criteriaHolder.getFilterCriteria() + "'");
    }

    private List<Parameter> buildPageParameters() {
        ArrayList<Parameter> pageParams = new ArrayList<Parameter>();
        pageParams.add(new Parameter().in(ParameterIn.QUERY.toString()).name("page.page").schema((Schema)new IntegerSchema()).description("Results page you want to retrieve (0..N)"));
        pageParams.add(new Parameter().in(ParameterIn.QUERY.toString()).name("page.size").schema((Schema)new IntegerSchema()).description("Number of records per page"));
        pageParams.add(new Parameter().in(ParameterIn.QUERY.toString()).name("page.sort").schema((Schema)new StringSchema()).description("Sorting criteria in the format: property, (asc|desc). Default sort order is ascending. Multiple sort criteria are supported."));
        return pageParams;
    }

    private void setParameters(Operation operation, Collection<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            operation.addParametersItem(parameter);
        }
    }

    private String getPathValue() {
        return StringUtils.isEmpty((CharSequence)this.pathValue) || this.pathValue.equals("/") ? "/api" : this.pathValue;
    }

    static {
        SpringDocUtils.getConfig().addAnnotationsToIgnore(new Class[]{AuthenticationPrincipal.class});
        SpringDocUtils.getConfig().addRequestWrapperToIgnore(new Class[]{Pageable.class, Queryable.class, ReportPortalUser.class, UserRole.class});
        hiddenParams = ImmutableSet.builder().add((Object)"attributeName").build();
        ATTRIBUTE_TO_FILTER_PREFIX = new HashMap<String, String>();
        ATTRIBUTE_TO_FILTER_PREFIX.put("compositeAttribute", "filter.has.");
        ATTRIBUTE_TO_FILTER_PREFIX.put("compositeSystemAttribute", "filter.has.");
    }
}

