/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.ws.resolver.ActiveUserWebArgumentResolver;
import com.epam.ta.reportportal.ws.resolver.FilterCriteriaResolver;
import com.epam.ta.reportportal.ws.resolver.JsonViewSupportFactoryBean;
import com.epam.ta.reportportal.ws.resolver.PagingHandlerMethodArgumentResolver;
import com.epam.ta.reportportal.ws.resolver.PredefinedFilterCriteriaResolver;
import com.epam.ta.reportportal.ws.resolver.SortArgumentResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.validation.beanvalidation.BeanValidationPostProcessor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MvcConfig
implements WebMvcConfigurer {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private List<HttpMessageConverter<?>> converters;
    private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/public/", "classpath:/META-INF/resources/", "classpath:/resources/"};

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (!registry.hasMappingForPattern("/**")) {
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(CLASSPATH_RESOURCE_LOCATIONS);
        }
        if (!registry.hasMappingForPattern("/webjars/**")) {
            registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        }
    }

    @Bean
    public SortArgumentResolver sortArgumentResolver() {
        SortArgumentResolver argumentResolver = new SortArgumentResolver();
        argumentResolver.setSortParameter("page.sort");
        argumentResolver.setQualifierDelimiter("+");
        return argumentResolver;
    }

    @Bean
    public JsonViewSupportFactoryBean jsonViewSupportFactoryBean() {
        return new JsonViewSupportFactoryBean();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.clear();
        PagingHandlerMethodArgumentResolver pageableResolver = new PagingHandlerMethodArgumentResolver(this.sortArgumentResolver());
        pageableResolver.setPrefix("page.");
        pageableResolver.setOneIndexedParameters(true);
        argumentResolvers.add((HandlerMethodArgumentResolver)pageableResolver);
        argumentResolvers.add(new ActiveUserWebArgumentResolver());
        argumentResolvers.add(new FilterCriteriaResolver());
        argumentResolvers.add(new PredefinedFilterCriteriaResolver());
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.clear();
        converters.add((HttpMessageConverter<?>)this.byteArrayConverter());
        converters.add((HttpMessageConverter<?>)this.jsonConverter());
        converters.add((HttpMessageConverter<?>)this.openMetricsTextStringConverter());
        converters.add((HttpMessageConverter<?>)this.stringConverter());
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false);
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseSuffixPatternMatch(Boolean.valueOf(false));
    }

    @Bean
    public BeanValidationPostProcessor beanValidationPostProcessor() {
        return new BeanValidationPostProcessor();
    }

    @Bean
    public MappingJackson2HttpMessageConverter jsonConverter() {
        return new MappingJackson2HttpMessageConverter(this.objectMapper);
    }

    @Bean
    public StringHttpMessageConverter stringConverter() {
        StringHttpMessageConverter converter = new StringHttpMessageConverter();
        converter.setSupportedMediaTypes(Collections.singletonList(MediaType.TEXT_PLAIN));
        return converter;
    }

    @Bean
    public StringHttpMessageConverter openMetricsTextStringConverter() {
        StringHttpMessageConverter converter = new StringHttpMessageConverter();
        converter.setSupportedMediaTypes(Collections.singletonList(new MediaType("application", "openmetrics-text", StandardCharsets.UTF_8)));
        return converter;
    }

    @Bean
    public ByteArrayHttpMessageConverter byteArrayConverter() {
        return new ByteArrayHttpMessageConverter();
    }

    @Bean
    HttpMessageConverters httpMessageConverters() {
        return new HttpMessageConverters(this.converters);
    }
}

