/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.strategy;

import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.starter.LaunchAutoAnalysisStarter;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.config.StartLaunchAutoAnalysisConfig;
import com.epam.ta.reportportal.core.analyzer.strategy.AbstractLaunchAnalysisStrategy;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.AnalyzeMode;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.model.launch.AnalyzeLaunchRQ;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchAutoAnalysisStrategy
extends AbstractLaunchAnalysisStrategy {
    private final LaunchAutoAnalysisStarter manualAnalysisStarter;

    @Autowired
    public LaunchAutoAnalysisStrategy(ProjectRepository projectRepository, LaunchRepository launchRepository, LaunchAutoAnalysisStarter manualAnalysisStarter) {
        super(projectRepository, launchRepository);
        this.manualAnalysisStarter = manualAnalysisStarter;
    }

    @Override
    public void analyze(AnalyzeLaunchRQ analyzeRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        AnalyzeMode analyzeMode = (AnalyzeMode)AnalyzeMode.fromString((String)analyzeRQ.getAnalyzerHistoryMode()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{analyzeRQ.getAnalyzerHistoryMode()}));
        LinkedHashSet<AnalyzeItemsMode> analyzeItemsModes = this.getAnalyzeItemsModes(analyzeRQ);
        if (analyzeItemsModes.isEmpty()) {
            return;
        }
        Launch launch = (Launch)this.launchRepository.findById((Object)analyzeRQ.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{analyzeRQ.getLaunchId()}));
        this.validateLaunch(launch, projectDetails);
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()}));
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(project);
        analyzerConfig.setAnalyzerMode(analyzeMode.getValue());
        StartLaunchAutoAnalysisConfig autoAnalysisConfig = StartLaunchAutoAnalysisConfig.of(launch.getId(), analyzerConfig, analyzeItemsModes, user);
        this.manualAnalysisStarter.start(autoAnalysisConfig);
    }

    private LinkedHashSet<AnalyzeItemsMode> getAnalyzeItemsModes(AnalyzeLaunchRQ analyzeRQ) {
        return analyzeRQ.getAnalyzeItemsModes().stream().map(AnalyzeItemsMode::fromString).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

