/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.service.impl;

import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.analyzer.pattern.service.impl.CreatePatternTemplateHandlerImpl;
import com.epam.ta.reportportal.dao.PatternTemplateRepository;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.model.project.config.pattern.CreatePatternTemplateRQ;
import jakarta.persistence.PersistenceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateRegexPatternTemplateHandler
extends CreatePatternTemplateHandlerImpl {
    @Autowired
    public CreateRegexPatternTemplateHandler(PatternTemplateRepository patternTemplateRepository) {
        super(patternTemplateRepository);
    }

    @Override
    public PatternTemplate createPatternTemplate(Long projectId, CreatePatternTemplateRQ createPatternTemplateRQ) {
        try {
            this.patternTemplateRepository.validateRegex(createPatternTemplateRQ.getValue());
        }
        catch (PersistenceException ex) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Provided regex pattern - '{}' is invalid", (Object[])new Object[]{createPatternTemplateRQ.getValue()}).get()});
        }
        return super.createPatternTemplate(projectId, createPatternTemplateRQ);
    }
}

