/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.config;

import com.epam.ta.reportportal.entity.pattern.PatternTemplateType;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PatternAnalysisRabbitConfiguration {
    public static final String PATTERN_ANALYSIS = "pattern.analysis";
    public static final String PATTERN_ANALYSIS_STRING = "analysis.pattern.string";
    public static final String PATTERN_ANALYSIS_REGEX = "analysis.pattern.regex";

    @Bean
    public Exchange patternAnalysisExchange() {
        return new DirectExchange(PATTERN_ANALYSIS);
    }

    @Bean
    public Queue patternAnalysisStringQueue() {
        return QueueBuilder.durable((String)PATTERN_ANALYSIS_STRING).build();
    }

    @Bean
    public Queue patternAnalysisRegexQueue() {
        return QueueBuilder.durable((String)PATTERN_ANALYSIS_REGEX).build();
    }

    @Bean
    public Binding stringQueueBinding() {
        return BindingBuilder.bind((Queue)this.patternAnalysisStringQueue()).to(this.patternAnalysisExchange()).with(PatternTemplateType.STRING.toString()).noargs();
    }

    @Bean
    public Binding regexQueueBinding() {
        return BindingBuilder.bind((Queue)this.patternAnalysisRegexQueue()).to(this.patternAnalysisExchange()).with(PatternTemplateType.REGEX.toString()).noargs();
    }

    @Bean
    public RabbitListenerContainerFactory<SimpleMessageListenerContainer> patternAnalysisContainerFactory(ConnectionFactory connectionFactory, SimpleRabbitListenerContainerFactoryConfigurer configurer, @Value(value="${rp.environment.variable.pattern-analysis.consumers-count:1}") int consumersCount, @Value(value="${rp.environment.variable.pattern-analysis.prefetch-count:0}") int prefetchCount) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConcurrentConsumers(Integer.valueOf(consumersCount));
        factory.setPrefetchCount(Integer.valueOf(prefetchCount));
        factory.setDefaultRequeueRejected(Boolean.valueOf(false));
        configurer.configure(factory, connectionFactory);
        return factory;
    }
}

