/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.strategy.search;

import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.CurrentLaunchCollector;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.FilterCollector;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.LaunchNameCollector;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.SearchCollectorFactory;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.SearchLaunchesCollector;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.SearchLogsMode;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SearchCollectorConfig {
    private ApplicationContext applicationContext;

    public SearchCollectorConfig(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Bean(value={"searchModeMapping"})
    public Map<SearchLogsMode, SearchLaunchesCollector> getSearchModeMapping() {
        return ImmutableMap.builder().put((Object)SearchLogsMode.BY_LAUNCH_NAME, (Object)((SearchLaunchesCollector)this.applicationContext.getBean(LaunchNameCollector.class))).put((Object)SearchLogsMode.CURRENT_LAUNCH, (Object)((SearchLaunchesCollector)this.applicationContext.getBean(CurrentLaunchCollector.class))).put((Object)SearchLogsMode.FILTER, (Object)((SearchLaunchesCollector)this.applicationContext.getBean(FilterCollector.class))).build();
    }

    @Bean
    public SearchCollectorFactory searchCollectorFactory() {
        return new SearchCollectorFactory(this.getSearchModeMapping());
    }
}

