/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.starter;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.AnalyzerService;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.starter.LaunchAutoAnalysisStarter;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeCollectorFactory;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.config.StartLaunchAutoAnalysisConfig;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.entity.launch.Launch;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class CollectingAutoAnalysisStarter
implements LaunchAutoAnalysisStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectingAutoAnalysisStarter.class);
    private final GetLaunchHandler getLaunchHandler;
    private final AnalyzeCollectorFactory analyzeCollectorFactory;
    private final AnalyzerService analyzerService;
    private final LogIndexer logIndexer;

    public CollectingAutoAnalysisStarter(GetLaunchHandler getLaunchHandler, AnalyzeCollectorFactory analyzeCollectorFactory, AnalyzerService analyzerService, LogIndexer logIndexer) {
        this.getLaunchHandler = getLaunchHandler;
        this.analyzeCollectorFactory = analyzeCollectorFactory;
        this.analyzerService = analyzerService;
        this.logIndexer = logIndexer;
    }

    @Override
    @Transactional
    public void start(StartLaunchAutoAnalysisConfig config) {
        Launch launch = this.getLaunchHandler.get(config.getLaunchId());
        List<Long> itemIds = this.collectItemsByModes(launch, config.getAnalyzeItemsModes(), config.getUser());
        this.analyzerService.runAnalyzers(launch, itemIds, config.getAnalyzerConfig());
        this.logIndexer.indexItemsLogs(launch.getProjectId(), launch.getId(), itemIds, config.getAnalyzerConfig());
    }

    private List<Long> collectItemsByModes(Launch launch, Set<AnalyzeItemsMode> analyzeItemsModes, ReportPortalUser user) {
        return analyzeItemsModes.stream().flatMap(it -> {
            List<Long> itemIds = this.analyzeCollectorFactory.getCollector((AnalyzeItemsMode)((Object)it)).collectItems(launch.getProjectId(), launch.getId(), user);
            LOGGER.debug("Item itemIds collected by '{}' mode: {}", (Object)it, itemIds);
            return itemIds.stream();
        }).distinct().collect(Collectors.toList());
    }
}

