/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.indexer;

import com.epam.reportportal.model.analyzer.IndexLaunch;
import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.ta.reportportal.core.analyzer.auto.client.IndexerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.preparer.LaunchPreparerService;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.jooq.enums.JLaunchModeEnum;
import com.epam.ta.reportportal.jooq.enums.JStatusEnum;
import com.epam.ta.reportportal.jooq.enums.JTestItemTypeEnum;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BatchLogIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchLogIndexer.class);
    private final Integer launchBatchSize;
    private final Integer itemsBatchSize;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final LaunchPreparerService launchPreparerService;
    private final IndexerServiceClient indexerServiceClient;

    @Autowired
    public BatchLogIndexer(@Value(value="${rp.environment.variable.log-index.batch-size}") Integer launchBatchSize, @Value(value="${rp.environment.variable.item-analyze.batch-size}") Integer itemsBatchSize, LaunchRepository launchRepository, TestItemRepository testItemRepository, LaunchPreparerService launchPreparerService, IndexerServiceClient indexerServiceClient) {
        this.launchBatchSize = launchBatchSize;
        this.itemsBatchSize = itemsBatchSize;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.launchPreparerService = launchPreparerService;
        this.indexerServiceClient = indexerServiceClient;
    }

    @Transactional(readOnly=true)
    public Long index(Long projectId, AnalyzerConfig analyzerConfig) {
        AtomicLong totalIndexed = new AtomicLong(0L);
        List<Long> ids = this.getLaunchIds(projectId);
        this.index(projectId, analyzerConfig, ids, totalIndexed);
        while (this.launchBatchSize.intValue() == ids.size()) {
            Long lastLaunchId = (Long)Iterables.getLast(ids);
            ids = this.getLaunchIds(projectId, lastLaunchId);
            this.index(projectId, analyzerConfig, ids, totalIndexed);
        }
        return totalIndexed.get();
    }

    @Transactional(readOnly=true)
    public Long index(AnalyzerConfig analyzerConfig, Launch launch, List<Long> itemIds) {
        AtomicLong indexedCount = new AtomicLong(0L);
        Iterables.partition(itemIds, (int)this.itemsBatchSize).forEach(partition -> indexedCount.addAndGet(this.indexPartition((List<Long>)partition, analyzerConfig, launch)));
        return indexedCount.get();
    }

    private Long indexPartition(List<Long> itemIds, AnalyzerConfig analyzerConfig, Launch launch) {
        LOGGER.info("Indexing started for {} items.", (Object)itemIds.size());
        Optional<IndexLaunch> prepared = this.launchPreparerService.prepare(launch, this.testItemRepository.findAllById(itemIds), analyzerConfig);
        prepared.ifPresent(it -> this.indexerServiceClient.index(Lists.newArrayList((Object[])new IndexLaunch[]{it})));
        Long indexedLogs = 0L;
        if (prepared.isPresent()) {
            indexedLogs = this.countLogs(Lists.newArrayList((Object[])new IndexLaunch[]{prepared.get()}));
        }
        LOGGER.info("Indexing of {} logs is finished for {} items.", (Object)indexedLogs, (Object)itemIds.size());
        return indexedLogs;
    }

    private Long countLogs(List<IndexLaunch> indexLaunch) {
        return indexLaunch.stream().flatMap(launch -> launch.getTestItems().stream()).mapToLong(item -> item.getLogs() != null ? (long)item.getLogs().size() : 0L).sum();
    }

    private void index(Long projectId, AnalyzerConfig analyzerConfig, List<Long> launchIds, AtomicLong totalIndexed) {
        if (launchIds.isEmpty()) {
            return;
        }
        LOGGER.debug("Project {}. Found {} ids", (Object)projectId, (Object)launchIds.size());
        List<Long> filteredIds = this.filterIds(launchIds);
        if (filteredIds.isEmpty()) {
            return;
        }
        LOGGER.debug("Project {}. Found {} filtered ids", (Object)projectId, (Object)filteredIds.size());
        List<IndexLaunch> preparedLaunches = this.launchPreparerService.prepare(launchIds, analyzerConfig);
        if (preparedLaunches.isEmpty()) {
            return;
        }
        LOGGER.debug("Project {}. Start indexing for {} launches", (Object)projectId, (Object)preparedLaunches.size());
        this.indexByPartition(preparedLaunches);
        long indexed = this.countLogs(preparedLaunches);
        LOGGER.debug("Project {}. Indexed {} logs", (Object)projectId, (Object)indexed);
        totalIndexed.addAndGet(indexed);
    }

    private void indexByPartition(List<IndexLaunch> preparedLaunches) {
        preparedLaunches.forEach(indexLaunch -> {
            Iterable lists = Iterables.partition((Iterable)indexLaunch.getTestItems(), (int)this.itemsBatchSize);
            StreamSupport.stream(lists.spliterator(), false).forEach(partition -> {
                indexLaunch.setTestItems(partition);
                this.indexerServiceClient.index(Lists.newArrayList((Object[])new IndexLaunch[]{indexLaunch}));
            });
        });
    }

    private List<Long> filterIds(List<Long> launchIds) {
        return launchIds.stream().filter(id -> this.launchRepository.hasItemsWithLogsWithLogLevel(id, List.of(JTestItemTypeEnum.STEP), Integer.valueOf(40000))).collect(Collectors.toList());
    }

    private List<Long> getLaunchIds(Long projectId) {
        return this.launchRepository.findIdsByProjectIdAndModeAndStatusNotEq(projectId, JLaunchModeEnum.DEFAULT, JStatusEnum.IN_PROGRESS, this.launchBatchSize.intValue());
    }

    private List<Long> getLaunchIds(Long projectId, Long launchId) {
        return this.launchRepository.findIdsByProjectIdAndModeAndStatusNotEqAfterId(projectId, JLaunchModeEnum.DEFAULT, JStatusEnum.IN_PROGRESS, launchId, this.launchBatchSize.intValue());
    }
}

