/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl.preparer;

import com.epam.reportportal.model.analyzer.IndexLaunch;
import com.epam.reportportal.model.analyzer.IndexTestItem;
import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.analyzer.auto.impl.preparer.LaunchPreparerService;
import com.epam.ta.reportportal.core.analyzer.auto.impl.preparer.TestItemPreparerService;
import com.epam.ta.reportportal.dao.ClusterRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.cluster.Cluster;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.util.Predicates;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchPreparerServiceImpl
implements LaunchPreparerService {
    private final LaunchRepository launchRepository;
    private final ClusterRepository clusterRepository;
    private final TestItemPreparerService testItemPreparerService;

    @Autowired
    public LaunchPreparerServiceImpl(LaunchRepository launchRepository, ClusterRepository clusterRepository, TestItemPreparerService testItemPreparerService) {
        this.launchRepository = launchRepository;
        this.clusterRepository = clusterRepository;
        this.testItemPreparerService = testItemPreparerService;
    }

    @Override
    public Optional<IndexLaunch> prepare(Launch launch, List<TestItem> testItems, AnalyzerConfig analyzerConfig) {
        List<IndexTestItem> preparedItems;
        if (Predicates.LAUNCH_CAN_BE_INDEXED.test(launch) && CollectionUtils.isNotEmpty(preparedItems = this.testItemPreparerService.prepare(launch.getId(), testItems))) {
            return Optional.of(this.createIndexLaunch(launch.getProjectId(), launch.getId(), launch.getName(), launch.getStartTime(), analyzerConfig, preparedItems, launch.getNumber()));
        }
        return Optional.empty();
    }

    private IndexLaunch createIndexLaunch(Long projectId, Long launchId, String name, Instant startLaunchTime, AnalyzerConfig analyzerConfig, List<IndexTestItem> rqTestItems, Long launchNumber) {
        IndexLaunch rqLaunch = new IndexLaunch();
        rqLaunch.setLaunchId(launchId);
        rqLaunch.setLaunchName(name);
        rqLaunch.setLaunchStartTime(LocalDateTime.ofInstant(startLaunchTime, ZoneId.systemDefault()));
        rqLaunch.setProjectId(projectId);
        rqLaunch.setAnalyzerConfig(analyzerConfig);
        rqLaunch.setTestItems(rqTestItems);
        rqLaunch.setLaunchNumber(launchNumber);
        this.setClusters(rqLaunch);
        return rqLaunch;
    }

    @Override
    public Optional<IndexLaunch> prepare(Long id, AnalyzerConfig analyzerConfig) {
        return this.prepare(List.of(id), analyzerConfig).stream().findFirst();
    }

    @Override
    public List<IndexLaunch> prepare(List<Long> ids, AnalyzerConfig analyzerConfig) {
        return this.launchRepository.findIndexLaunchByIds(ids).stream().peek(this::fill).filter(l -> CollectionUtils.isNotEmpty((Collection)l.getTestItems())).peek(l -> l.setAnalyzerConfig(analyzerConfig)).collect(Collectors.toList());
    }

    private void fill(IndexLaunch indexLaunch) {
        List<IndexTestItem> preparedItems = this.testItemPreparerService.prepare(indexLaunch.getLaunchId());
        if (!preparedItems.isEmpty()) {
            indexLaunch.setTestItems(preparedItems);
            this.setClusters(indexLaunch);
        }
    }

    @Override
    public List<IndexLaunch> prepare(AnalyzerConfig analyzerConfig, List<TestItem> testItems) {
        return testItems.stream().collect(Collectors.groupingBy(TestItem::getLaunchId)).entrySet().stream().flatMap(entry -> {
            Launch launch = (Launch)this.launchRepository.findById((Object)((Long)entry.getKey())).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{entry.getKey()}));
            return this.prepare(launch, (List)entry.getValue(), analyzerConfig).stream();
        }).collect(Collectors.toList());
    }

    private void setClusters(IndexLaunch indexLaunch) {
        Map<Long, String> clusters = this.clusterRepository.findAllByLaunchId(indexLaunch.getLaunchId()).stream().collect(Collectors.toMap(Cluster::getIndexId, Cluster::getMessage));
        if (!clusters.isEmpty()) {
            indexLaunch.setClusters(clusters);
        }
    }
}

