/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.reportportal.model.analyzer.IndexLaunch;
import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.client.IndexerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.preparer.LaunchPreparerService;
import com.epam.ta.reportportal.core.analyzer.auto.indexer.BatchLogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.indexer.IndexerStatusCache;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogIndexerService
implements LogIndexer {
    private static Logger LOGGER = LoggerFactory.getLogger(LogIndexerService.class);
    private final BatchLogIndexer batchLogIndexer;
    private final TaskExecutor taskExecutor;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final IndexerServiceClient indexerServiceClient;
    private final LaunchPreparerService launchPreparerService;
    private final IndexerStatusCache indexerStatusCache;

    @Autowired
    public LogIndexerService(BatchLogIndexer batchLogIndexer, @Qualifier(value="logIndexTaskExecutor") TaskExecutor taskExecutor, LaunchRepository launchRepository, TestItemRepository testItemRepository, IndexerServiceClient indexerServiceClient, LaunchPreparerService launchPreparerService, IndexerStatusCache indexerStatusCache) {
        this.batchLogIndexer = batchLogIndexer;
        this.taskExecutor = taskExecutor;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.indexerServiceClient = indexerServiceClient;
        this.launchPreparerService = launchPreparerService;
        this.indexerStatusCache = indexerStatusCache;
    }

    @Override
    public CompletableFuture<Long> index(Long projectId, AnalyzerConfig analyzerConfig) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                LOGGER.info("Start indexing for project: {}", (Object)projectId);
                this.indexerStatusCache.indexingStarted(projectId);
                Long indexed = this.batchLogIndexer.index(projectId, analyzerConfig);
                LOGGER.info("Indexing finished for project: {}. Logs indexed: {}", (Object)projectId, (Object)indexed);
                Long l = indexed;
                return l;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ReportPortalException(e.getMessage());
            }
            finally {
                this.indexerStatusCache.indexingFinished(projectId);
            }
        }, (Executor)this.taskExecutor);
    }

    @Override
    @Transactional(readOnly=true)
    public Long indexLaunchLogs(Launch launch, AnalyzerConfig analyzerConfig) {
        try {
            this.indexerStatusCache.indexingStarted(launch.getProjectId());
            List itemIds = this.testItemRepository.selectIdsWithIssueByLaunch(launch.getId());
            Long l = this.batchLogIndexer.index(analyzerConfig, launch, itemIds);
            return l;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ReportPortalException(e.getMessage());
        }
        finally {
            this.indexerStatusCache.indexingFinished(launch.getProjectId());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Long indexItemsLogs(Long projectId, Long launchId, List<Long> itemIds, AnalyzerConfig analyzerConfig) {
        try {
            this.indexerStatusCache.indexingStarted(projectId);
            Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
            Long l = this.batchLogIndexer.index(analyzerConfig, launch, itemIds);
            return l;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ReportPortalException(e.getMessage());
        }
        finally {
            this.indexerStatusCache.indexingFinished(projectId);
        }
    }

    @Override
    public void deleteIndex(Long project) {
        this.indexerServiceClient.deleteIndex(project);
    }

    @Override
    public CompletableFuture<Long> cleanIndex(Long index, List<Long> ids) {
        return CollectionUtils.isEmpty(ids) ? CompletableFuture.completedFuture(0L) : CompletableFuture.supplyAsync(() -> this.indexerServiceClient.cleanIndex(index, ids));
    }

    @Override
    @Async
    public void indexDefectsUpdate(Long projectId, AnalyzerConfig analyzerConfig, List<TestItem> testItems) {
        if (CollectionUtils.isEmpty(testItems)) {
            return;
        }
        Map<Long, String> itemsForIndexUpdate = testItems.stream().collect(Collectors.toMap(TestItem::getItemId, it -> it.getItemResults().getIssue().getIssueType().getLocator()));
        List<Long> missedItemIds = this.indexerServiceClient.indexDefectsUpdate(projectId, itemsForIndexUpdate);
        List<TestItem> missedItems = testItems.stream().filter(it -> missedItemIds.contains(it.getItemId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(missedItems)) {
            List<IndexLaunch> indexLaunchList = this.launchPreparerService.prepare(analyzerConfig, missedItems);
            this.indexerServiceClient.index(indexLaunchList);
        }
    }

    @Override
    public int indexItemsRemove(Long projectId, Collection<Long> itemsForIndexRemove) {
        return this.indexerServiceClient.indexItemsRemove(projectId, itemsForIndexRemove);
    }

    @Override
    @Async
    public void indexItemsRemoveAsync(Long projectId, Collection<Long> itemsForIndexRemove) {
        this.indexerServiceClient.indexItemsRemoveAsync(projectId, itemsForIndexRemove);
    }

    @Override
    @Async
    public void indexLaunchesRemove(Long projectId, Collection<Long> launchesForIndexRemove) {
        this.indexerServiceClient.indexLaunchesRemove(projectId, launchesForIndexRemove);
    }
}

