/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core;

import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElementsCounterService {
    private final Integer batchSize;
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;

    @Autowired
    public ElementsCounterService(@Value(value="${rp.environment.variable.elements-counter.batch-size}") Integer batchSize, TestItemRepository testItemRepository, LogRepository logRepository) {
        this.batchSize = batchSize;
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
    }

    public Long countNumberOfLaunchElements(Long launchId) {
        AtomicLong resultedNumber = new AtomicLong(1L);
        List testItemIdsByLaunchId = this.testItemRepository.findIdsByLaunchId(launchId);
        resultedNumber.addAndGet(testItemIdsByLaunchId.size());
        resultedNumber.addAndGet(this.logRepository.countLogsByLaunchId(launchId));
        Lists.partition((List)testItemIdsByLaunchId, (int)this.batchSize).forEach(batch -> resultedNumber.addAndGet(this.logRepository.countLogsByTestItemItemIdIn(batch)));
        return resultedNumber.longValue();
    }

    public Long countNumberOfItemElements(TestItem item) {
        if (item != null) {
            List itemIds = this.testItemRepository.selectAllDescendantsIds(item.getPath());
            AtomicLong resultedNumber = new AtomicLong(itemIds.size());
            resultedNumber.addAndGet(this.logRepository.countLogsByTestItemItemIdIn(itemIds));
            if (item.isHasRetries()) {
                List retryIds = this.testItemRepository.findIdsByRetryOf(item.getItemId());
                List nestedPaths = this.testItemRepository.findPathsByParentIds(retryIds.toArray(new Long[0]));
                nestedPaths.forEach(path -> {
                    List nestedChild = this.testItemRepository.selectAllDescendantsIds(path);
                    resultedNumber.addAndGet(nestedChild.size());
                    resultedNumber.addAndGet(this.logRepository.countLogsByTestItemItemIdIn(nestedChild));
                });
            }
            return resultedNumber.longValue();
        }
        return 0L;
    }

    public Long countNumberOfItemElements(List<TestItem> items) {
        if (!CollectionUtils.isEmpty(items)) {
            AtomicLong resultedNumber = new AtomicLong(0L);
            items.forEach(item -> resultedNumber.addAndGet(this.countNumberOfItemElements((TestItem)item)));
            return resultedNumber.get();
        }
        return 0L;
    }
}

