/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.auth.permissions.Permission;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.security.core.Authentication;

abstract class BaseProjectPermission
implements Permission {
    private final ProjectExtractor projectExtractor;

    protected BaseProjectPermission(ProjectExtractor projectExtractor) {
        this.projectExtractor = projectExtractor;
    }

    @Override
    public boolean isAllowed(Authentication authentication, Object projectName) {
        if (!authentication.isAuthenticated()) {
            return false;
        }
        ReportPortalUser rpUser = (ReportPortalUser)authentication.getPrincipal();
        BusinessRule.expect((Object)rpUser, Objects::nonNull).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        String resolvedProjectName = String.valueOf(projectName);
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.findProjectDetails(rpUser, resolvedProjectName).orElseThrow(() -> new ReportPortalException(ErrorType.ACCESS_DENIED, new Object[0]));
        this.fillProjectDetails(rpUser, resolvedProjectName, projectDetails);
        ProjectRole role = projectDetails.getProjectRole();
        return this.checkAllowed(rpUser, projectName.toString(), role);
    }

    private void fillProjectDetails(ReportPortalUser rpUser, String resolvedProjectName, ReportPortalUser.ProjectDetails projectDetails) {
        HashMap projectDetailsMapping = Maps.newHashMapWithExpectedSize((int)1);
        projectDetailsMapping.put(resolvedProjectName, projectDetails);
        rpUser.setProjectDetails((Map)projectDetailsMapping);
    }

    protected abstract boolean checkAllowed(ReportPortalUser var1, String var2, ProjectRole var3);
}

