/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;

public class ApiKeyUtils {
    private static final String UUID_PATTERN = "^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$";

    private ApiKeyUtils() {
    }

    public static boolean validateToken(String apiKey) {
        if (ApiKeyUtils.isUUID(apiKey) || apiKey.length() == 27 && Base64.getUrlDecoder().decode(apiKey.getBytes(StandardCharsets.US_ASCII)).length == 20) {
            return true;
        }
        String[] nameChecksum = apiKey.split("_", 2);
        try {
            byte[] checksumBytes = Base64.getUrlDecoder().decode(nameChecksum[1]);
            byte[] actualUuid = Arrays.copyOf(checksumBytes, 16);
            byte[] actualHash = Arrays.copyOfRange(checksumBytes, 16, checksumBytes.length);
            byte[] nameBytes = nameChecksum[0].getBytes(StandardCharsets.UTF_8);
            ByteBuffer nameUuidBb = ByteBuffer.wrap(new byte[nameBytes.length + actualUuid.length]);
            nameUuidBb.put(nameBytes);
            nameUuidBb.put(actualUuid);
            byte[] expected = DigestUtils.sha3_256((byte[])nameUuidBb.array());
            return Arrays.equals(actualHash, expected);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isUUID(String uuidStr) {
        Pattern pattern = Pattern.compile(UUID_PATTERN);
        Matcher matcher = pattern.matcher(uuidStr);
        return matcher.matches();
    }
}

