/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.epam.reportportal.api.model.Offset;
import com.epam.reportportal.api.model.ProjectGroupInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;

public class ProjectGroupsPage
extends Offset {
    @Valid
    private @Valid List<@Valid ProjectGroupInfo> items = new ArrayList<ProjectGroupInfo>();

    public ProjectGroupsPage() {
    }

    public ProjectGroupsPage(List<@Valid ProjectGroupInfo> items, Integer offset, Integer limit, @Nullable Integer totalCount, @Nullable String sort, @Nullable Sort.Direction order) {
        super(offset, limit, totalCount, sort, order);
        this.items = items;
    }

    public ProjectGroupsPage items(List<@Valid ProjectGroupInfo> items) {
        this.items = items;
        return this;
    }

    public ProjectGroupsPage addItemsItem(ProjectGroupInfo itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<ProjectGroupInfo>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Valid
    @Schema(name="items", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="items")
    public @Valid List<@Valid ProjectGroupInfo> getItems() {
        return this.items;
    }

    public void setItems(List<@Valid ProjectGroupInfo> items) {
        this.items = items;
    }

    @Override
    public ProjectGroupsPage offset(Integer offset) {
        super.offset(offset);
        return this;
    }

    @Override
    public ProjectGroupsPage limit(Integer limit) {
        super.limit(limit);
        return this;
    }

    @Override
    public ProjectGroupsPage totalCount(Integer totalCount) {
        super.totalCount(totalCount);
        return this;
    }

    @Override
    public ProjectGroupsPage sort(String sort) {
        super.sort(sort);
        return this;
    }

    @Override
    public ProjectGroupsPage order(Sort.Direction order) {
        super.order(order);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectGroupsPage projectGroupsPage = (ProjectGroupsPage)o;
        return Objects.equals(this.items, projectGroupsPage.items) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.items, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectGroupsPage {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder
    extends Offset.Builder {
        private ProjectGroupsPage instance;

        public Builder() {
            this(new ProjectGroupsPage());
        }

        protected Builder(ProjectGroupsPage instance) {
            super(instance);
            this.instance = instance;
        }

        protected Builder copyOf(ProjectGroupsPage value) {
            super.copyOf(value);
            this.instance.setItems(value.items);
            return this;
        }

        public Builder items(List<ProjectGroupInfo> items) {
            this.instance.items(items);
            return this;
        }

        @Override
        public Builder offset(Integer offset) {
            this.instance.offset(offset);
            return this;
        }

        @Override
        public Builder limit(Integer limit) {
            this.instance.limit(limit);
            return this;
        }

        @Override
        public Builder totalCount(Integer totalCount) {
            this.instance.totalCount(totalCount);
            return this;
        }

        @Override
        public Builder sort(String sort) {
            this.instance.sort(sort);
            return this;
        }

        @Override
        public Builder order(Sort.Direction order) {
            this.instance.order(order);
            return this;
        }

        @Override
        public ProjectGroupsPage build() {
            try {
                ProjectGroupsPage projectGroupsPage = this.instance;
                return projectGroupsPage;
            }
            finally {
                super.build();
                this.instance = null;
            }
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

