/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.epam.reportportal.api.model.GroupUserInfo;
import com.epam.reportportal.api.model.Offset;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;

@Schema(name="GroupUsersPage", description="Page of group users.")
public class GroupUsersPage
extends Offset {
    @Valid
    private @Valid List<@Valid GroupUserInfo> items = new ArrayList<GroupUserInfo>();

    public GroupUsersPage() {
    }

    public GroupUsersPage(List<@Valid GroupUserInfo> items, Integer offset, Integer limit, @Nullable Integer totalCount, @Nullable String sort, @Nullable Sort.Direction order) {
        super(offset, limit, totalCount, sort, order);
        this.items = items;
    }

    public GroupUsersPage items(List<@Valid GroupUserInfo> items) {
        this.items = items;
        return this;
    }

    public GroupUsersPage addItemsItem(GroupUserInfo itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<GroupUserInfo>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Valid
    @Schema(name="items", description="List of group users.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="items")
    public @Valid List<@Valid GroupUserInfo> getItems() {
        return this.items;
    }

    public void setItems(List<@Valid GroupUserInfo> items) {
        this.items = items;
    }

    @Override
    public GroupUsersPage offset(Integer offset) {
        super.offset(offset);
        return this;
    }

    @Override
    public GroupUsersPage limit(Integer limit) {
        super.limit(limit);
        return this;
    }

    @Override
    public GroupUsersPage totalCount(Integer totalCount) {
        super.totalCount(totalCount);
        return this;
    }

    @Override
    public GroupUsersPage sort(String sort) {
        super.sort(sort);
        return this;
    }

    @Override
    public GroupUsersPage order(Sort.Direction order) {
        super.order(order);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupUsersPage groupUsersPage = (GroupUsersPage)o;
        return Objects.equals(this.items, groupUsersPage.items) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.items, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupUsersPage {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder
    extends Offset.Builder {
        private GroupUsersPage instance;

        public Builder() {
            this(new GroupUsersPage());
        }

        protected Builder(GroupUsersPage instance) {
            super(instance);
            this.instance = instance;
        }

        protected Builder copyOf(GroupUsersPage value) {
            super.copyOf(value);
            this.instance.setItems(value.items);
            return this;
        }

        public Builder items(List<GroupUserInfo> items) {
            this.instance.items(items);
            return this;
        }

        @Override
        public Builder offset(Integer offset) {
            this.instance.offset(offset);
            return this;
        }

        @Override
        public Builder limit(Integer limit) {
            this.instance.limit(limit);
            return this;
        }

        @Override
        public Builder totalCount(Integer totalCount) {
            this.instance.totalCount(totalCount);
            return this;
        }

        @Override
        public Builder sort(String sort) {
            this.instance.sort(sort);
            return this;
        }

        @Override
        public Builder order(Sort.Direction order) {
            this.instance.order(order);
            return this;
        }

        @Override
        public GroupUsersPage build() {
            try {
                GroupUsersPage groupUsersPage = this.instance;
                return groupUsersPage;
            }
            finally {
                super.build();
                this.instance = null;
            }
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

