/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.epam.reportportal.api.model.ProjectRole;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.time.Instant;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.lang.Nullable;

@Schema(name="GroupProjectInfo", description="Information about a project as a group member.")
public class GroupProjectInfo {
    @Nullable
    private Long id;
    @Nullable
    private String name;
    private ProjectRole permission = ProjectRole.MEMBER;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Nullable
    private Instant addedAt;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Nullable
    private Instant updatedAt;

    public GroupProjectInfo() {
    }

    public GroupProjectInfo(@Nullable Long id, @Nullable String name, ProjectRole permission, @Nullable Instant addedAt, @Nullable Instant updatedAt) {
        this.id = id;
        this.name = name;
        this.permission = permission;
        this.addedAt = addedAt;
        this.updatedAt = updatedAt;
    }

    public GroupProjectInfo id(Long id) {
        this.id = id;
        return this;
    }

    @Min(value=1L)
    @Schema(name="id", description="Resource identifier.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public @Min(value=1L) Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public GroupProjectInfo name(String name) {
        this.name = name;
        return this;
    }

    @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$")
    @Size(min=3, max=60)
    @Schema(name="name", description="Display name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$") @Size(min=3, max=60) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroupProjectInfo permission(ProjectRole permission) {
        this.permission = permission;
        return this;
    }

    @Valid
    @Schema(name="permission", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="permission")
    public ProjectRole getPermission() {
        return this.permission;
    }

    public void setPermission(ProjectRole permission) {
        this.permission = permission;
    }

    public GroupProjectInfo addedAt(Instant addedAt) {
        this.addedAt = addedAt;
        return this;
    }

    @Valid
    @Schema(name="added_at", description="Timestamp of project adding to group.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="added_at")
    public Instant getAddedAt() {
        return this.addedAt;
    }

    public void setAddedAt(Instant addedAt) {
        this.addedAt = addedAt;
    }

    public GroupProjectInfo updatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Valid
    @Schema(name="updated_at", description="Timestamp of project updating in group.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="updated_at")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupProjectInfo groupProjectInfo = (GroupProjectInfo)o;
        return Objects.equals(this.id, groupProjectInfo.id) && Objects.equals(this.name, groupProjectInfo.name) && Objects.equals((Object)this.permission, (Object)groupProjectInfo.permission) && Objects.equals(this.addedAt, groupProjectInfo.addedAt) && Objects.equals(this.updatedAt, groupProjectInfo.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.permission, this.addedAt, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupProjectInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString((Object)this.permission)).append("\n");
        sb.append("    addedAt: ").append(this.toIndentedString(this.addedAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder {
        private GroupProjectInfo instance;

        public Builder() {
            this(new GroupProjectInfo());
        }

        protected Builder(GroupProjectInfo instance) {
            this.instance = instance;
        }

        protected Builder copyOf(GroupProjectInfo value) {
            this.instance.setId(value.id);
            this.instance.setName(value.name);
            this.instance.setPermission(value.permission);
            this.instance.setAddedAt(value.addedAt);
            this.instance.setUpdatedAt(value.updatedAt);
            return this;
        }

        public Builder id(Long id) {
            this.instance.id(id);
            return this;
        }

        public Builder name(String name) {
            this.instance.name(name);
            return this;
        }

        public Builder permission(ProjectRole permission) {
            this.instance.permission(permission);
            return this;
        }

        public Builder addedAt(Instant addedAt) {
            this.instance.addedAt(addedAt);
            return this;
        }

        public Builder updatedAt(Instant updatedAt) {
            this.instance.updatedAt(updatedAt);
            return this;
        }

        public GroupProjectInfo build() {
            try {
                GroupProjectInfo groupProjectInfo = this.instance;
                return groupProjectInfo;
            }
            finally {
                this.instance = null;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

