/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.springframework.lang.Nullable;

@Schema(name="GroupInfo_stats", description="Group statistics.")
@JsonTypeName(value="GroupInfo_stats")
public class GroupInfoStats {
    @Nullable
    private Integer usersCount;
    @Nullable
    private Integer projectsCount;

    public GroupInfoStats() {
    }

    public GroupInfoStats(@Nullable Integer usersCount, @Nullable Integer projectsCount) {
        this.usersCount = usersCount;
        this.projectsCount = projectsCount;
    }

    public GroupInfoStats usersCount(Integer usersCount) {
        this.usersCount = usersCount;
        return this;
    }

    @Schema(name="users_count", description="Number of users in the group.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="users_count")
    public Integer getUsersCount() {
        return this.usersCount;
    }

    public void setUsersCount(Integer usersCount) {
        this.usersCount = usersCount;
    }

    public GroupInfoStats projectsCount(Integer projectsCount) {
        this.projectsCount = projectsCount;
        return this;
    }

    @Schema(name="projects_count", description="Number of projects in the group.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="projects_count")
    public Integer getProjectsCount() {
        return this.projectsCount;
    }

    public void setProjectsCount(Integer projectsCount) {
        this.projectsCount = projectsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupInfoStats groupInfoStats = (GroupInfoStats)o;
        return Objects.equals(this.usersCount, groupInfoStats.usersCount) && Objects.equals(this.projectsCount, groupInfoStats.projectsCount);
    }

    public int hashCode() {
        return Objects.hash(this.usersCount, this.projectsCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupInfoStats {\n");
        sb.append("    usersCount: ").append(this.toIndentedString(this.usersCount)).append("\n");
        sb.append("    projectsCount: ").append(this.toIndentedString(this.projectsCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder {
        private GroupInfoStats instance;

        public Builder() {
            this(new GroupInfoStats());
        }

        protected Builder(GroupInfoStats instance) {
            this.instance = instance;
        }

        protected Builder copyOf(GroupInfoStats value) {
            this.instance.setUsersCount(value.usersCount);
            this.instance.setProjectsCount(value.projectsCount);
            return this;
        }

        public Builder usersCount(Integer usersCount) {
            this.instance.usersCount(usersCount);
            return this;
        }

        public Builder projectsCount(Integer projectsCount) {
            this.instance.projectsCount(projectsCount);
            return this;
        }

        public GroupInfoStats build() {
            try {
                GroupInfoStats groupInfoStats = this.instance;
                return groupInfoStats;
            }
            finally {
                this.instance = null;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

