/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api;

import com.epam.reportportal.api.model.AddProjectToGroupByIdRequest;
import com.epam.reportportal.api.model.Problem;
import com.epam.reportportal.api.model.ProjectGroupInfo;
import com.epam.reportportal.api.model.ProjectGroupsPage;
import com.epam.reportportal.api.model.SuccessfulUpdate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="Projects", description="Generated project API collection")
public interface ProjectsApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="addGroupToProjectById", summary="Add or update group to project", description="Add or update group to project with permission.  ### Authority  - `ADMINISTRATOR` - `PROJECT MANAGER`", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="Successful update response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessfulUpdate.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=SuccessfulUpdate.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/projects/{project_name}/groups/{group_id}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    default public ResponseEntity<SuccessfulUpdate> addGroupToProjectById(@Parameter(name="project_name", description="Project name.", required=true, in=ParameterIn.PATH) @PathVariable(value="project_name") String projectName, @Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Parameter(name="AddProjectToGroupByIdRequest", description="") @Valid @RequestBody(required=false) AddProjectToGroupByIdRequest addProjectToGroupByIdRequest) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteGroupFromProjectById", summary="Delete group from project by id", description="Delete group from project by id.  ### Authority  - `ADMINISTRATOR` - `PROJECT MANAGER`", tags={"Projects"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/projects/{project_name}/groups/{group_id}"}, produces={"application/problem+json"})
    default public ResponseEntity<Void> deleteGroupFromProjectById(@Parameter(name="project_name", description="Project name.", required=true, in=ParameterIn.PATH) @PathVariable(value="project_name") String projectName, @Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getGroupsOfProject", summary="Get all groups of project", description="Get all groups of project.  ### Authority  - `ADMINISTRATOR` - `PROJECT MANAGER` - `MEMBETR` - `OPERATOR`", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectGroupsPage.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=ProjectGroupsPage.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/projects/{project_name}/groups"}, produces={"application/json", "application/problem+json"})
    default public ResponseEntity<ProjectGroupsPage> getGroupsOfProject(@Parameter(name="project_name", description="Project name.", required=true, in=ParameterIn.PATH) @PathVariable(value="project_name") String projectName, @Parameter(name="offset", description="The offset used for this page of results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @Min(value=0L) @Max(value=1000L) @Parameter(name="limit", description="The limit used for this page of results. This will be the same as the limit query parameter unless it exceeded the maximum value allowed for this API endpoint.", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false, defaultValue="300") @Min(value=0L) @Max(value=1000L) @Valid Integer limit) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getProjectGroupById", summary="Get group by id", description="Get group by id from project.  ### Authority  - `ADMINISTRATOR` - `PROJECT MANAGER`", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectGroupInfo.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=ProjectGroupInfo.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/projects/{project_name}/groups/{group_id}"}, produces={"application/json", "application/problem+json"})
    default public ResponseEntity<ProjectGroupInfo> getProjectGroupById(@Parameter(name="project_name", description="Project name.", required=true, in=ParameterIn.PATH) @PathVariable(value="project_name") String projectName, @Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

