/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.impl.io;

import rp.org.apache.http.HttpResponse;
import rp.org.apache.http.HttpResponseFactory;
import rp.org.apache.http.annotation.Contract;
import rp.org.apache.http.annotation.ThreadingBehavior;
import rp.org.apache.http.config.MessageConstraints;
import rp.org.apache.http.impl.DefaultHttpResponseFactory;
import rp.org.apache.http.impl.io.DefaultHttpResponseParser;
import rp.org.apache.http.io.HttpMessageParser;
import rp.org.apache.http.io.HttpMessageParserFactory;
import rp.org.apache.http.io.SessionInputBuffer;
import rp.org.apache.http.message.BasicLineParser;
import rp.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

