/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.convert.Converters;
import com.enonic.xp.lib.common.PrincipalMapper;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.EditableUser;
import com.enonic.xp.security.Principal;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.SecurityService;
import com.enonic.xp.security.UpdateUserParams;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public final class ModifyUserHandler
implements ScriptBean {
    private Supplier<SecurityService> securityService;
    private ScriptValue editor;
    private PrincipalKey principalKey;

    public void setEditor(ScriptValue editor) {
        this.editor = editor;
    }

    public void setPrincipalKey(String principalKey) {
        this.principalKey = PrincipalKey.from((String)principalKey);
    }

    public PrincipalMapper modifyUser() {
        Optional existingUser = this.securityService.get().getUser(this.principalKey);
        if (existingUser.isPresent()) {
            UpdateUserParams params = UpdateUserParams.create().userKey(this.principalKey).editor(this::newUserEditor).build();
            return new PrincipalMapper((Principal)this.securityService.get().updateUser(params));
        }
        return null;
    }

    private void newUserEditor(EditableUser edit) {
        ScriptValue value = this.editor.call(new Object[]{new PrincipalMapper((Principal)edit.source)});
        if (value != null) {
            this.updateUser(edit, value.getMap());
        }
    }

    private void updateUser(EditableUser target, Map map) {
        String email;
        String displayName = (String)Converters.convert(map.get("displayName"), String.class);
        if (displayName != null) {
            target.displayName = displayName;
        }
        if ((email = (String)Converters.convert(map.get("email"), String.class)) != null) {
            target.email = email;
        }
    }

    public void initialize(BeanContext context) {
        this.securityService = context.getService(SecurityService.class);
    }
}

