/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.convert.Converters;
import com.enonic.xp.lib.common.PrincipalMapper;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.EditableRole;
import com.enonic.xp.security.Principal;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.SecurityService;
import com.enonic.xp.security.UpdateRoleParams;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public final class ModifyRoleHandler
implements ScriptBean {
    private Supplier<SecurityService> securityService;
    private ScriptValue editor;
    private PrincipalKey principalKey;

    public void setEditor(ScriptValue editor) {
        this.editor = editor;
    }

    public void setPrincipalKey(String principalKey) {
        this.principalKey = PrincipalKey.from((String)principalKey);
    }

    public PrincipalMapper modifyRole() {
        Optional existingRole = this.securityService.get().getRole(this.principalKey);
        if (existingRole.isPresent()) {
            UpdateRoleParams params = UpdateRoleParams.create().roleKey(this.principalKey).editor(this::newRoleEditor).build();
            return new PrincipalMapper((Principal)this.securityService.get().updateRole(params));
        }
        return null;
    }

    private void newRoleEditor(EditableRole edit) {
        ScriptValue value = this.editor.call(new Object[]{new PrincipalMapper((Principal)edit.source)});
        if (value != null) {
            this.updateRole(edit, value.getMap());
        }
    }

    private void updateRole(EditableRole target, Map map) {
        String description;
        String displayName = (String)Converters.convert(map.get("displayName"), String.class);
        if (displayName != null) {
            target.displayName = displayName;
        }
        if ((description = (String)Converters.convert(map.get("description"), String.class)) != null) {
            target.description = description;
        }
    }

    public void initialize(BeanContext context) {
        this.securityService = context.getService(SecurityService.class);
    }
}

