/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.data.PropertySet;
import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.lib.common.PropertyTreeMapper;
import com.enonic.xp.lib.value.ScriptValueTranslator;
import com.enonic.xp.lib.value.ScriptValueTranslatorResult;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.EditableUser;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.SecurityService;
import com.enonic.xp.security.UpdateUserParams;
import com.enonic.xp.security.User;
import java.util.Optional;
import java.util.function.Supplier;

public final class ModifyProfileHandler
implements ScriptBean {
    private Supplier<SecurityService> securityService;
    private PrincipalKey key;
    private String scope;
    private ScriptValue editor;

    public void setKey(String key) {
        this.key = PrincipalKey.from((String)key);
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setEditor(ScriptValue editor) {
        this.editor = editor;
    }

    public PropertyTreeMapper execute() {
        Optional user = this.securityService.get().getUser(this.key);
        if (user.isPresent()) {
            UpdateUserParams params = UpdateUserParams.create().userKey(this.key).editor(this::newProfileEditor).build();
            User updatedUser = this.securityService.get().updateUser(params);
            PropertyTree updatedProfile = updatedUser.getProfile();
            return this.createPropertyTreeMapper(updatedProfile, false);
        }
        return null;
    }

    private void newProfileEditor(EditableUser edit) {
        PropertyTree profile = edit.source.getProfile();
        PropertyTreeMapper mapper = this.createPropertyTreeMapper(profile, true);
        ScriptValue scriptValue = this.editor.call(new Object[]{mapper});
        this.updateUser(edit, scriptValue);
    }

    private PropertyTreeMapper createPropertyTreeMapper(PropertyTree profile, Boolean useRawValue) {
        if (profile == null) {
            return null;
        }
        if (this.scope == null) {
            return new PropertyTreeMapper(useRawValue.booleanValue(), profile);
        }
        PropertySet scopedProfile = profile.getSet(this.scope);
        return scopedProfile == null ? null : new PropertyTreeMapper(useRawValue.booleanValue(), scopedProfile.toTree());
    }

    private void updateUser(EditableUser target, ScriptValue value) {
        if (value == null) {
            if (this.scope != null) {
                target.profile.removeProperty(this.scope);
            }
            return;
        }
        ScriptValueTranslatorResult scriptValueTranslatorResult = new ScriptValueTranslator(false).create(value);
        PropertyTree propertyTree = scriptValueTranslatorResult.getPropertyTree();
        if (this.scope == null) {
            target.profile = propertyTree;
        } else {
            target.profile.setSet(this.scope, propertyTree.getRoot());
        }
    }

    public void initialize(BeanContext context) {
        this.securityService = context.getService(SecurityService.class);
    }
}

