/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;

public final class GeneratePasswordHandler {
    private static final String SPECIAL_CHARS = "!@#$%^&*()_+{}:\"<>?|[];',./`~";
    private static final String LOWERCASE_CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPERCASE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGIT_CHARS = "0123456789";
    private final SecureRandom random = new SecureRandom();

    public String generatePassword() {
        int length = this.getRandomNumberInRange(14, 16);
        int maxSpecials = this.getRandomNumberInRange(1, 3);
        int specials = 0;
        int maxDigits = this.getRandomNumberInRange(2, 4);
        int digits = 0;
        int maxUppercase = this.getRandomNumberInRange(2, 4);
        int uppercase = 0;
        int maxLowercase = length - maxSpecials - maxDigits - maxUppercase;
        int lowercase = 0;
        StringBuilder result = new StringBuilder();
        ArrayList<CharType> types = new ArrayList<CharType>(Arrays.asList(CharType.values()));
        block6: for (int i = 0; i < length; ++i) {
            CharType type = (CharType)((Object)types.get(this.getRandomNumberInRange(0, types.size() - 1)));
            switch (type) {
                case SPECIAL: {
                    if (specials < maxSpecials) {
                        result.append(SPECIAL_CHARS.charAt(this.getRandomNumberInRange(0, SPECIAL_CHARS.length() - 1)));
                        ++specials;
                        continue block6;
                    }
                    --i;
                    types.remove((Object)CharType.SPECIAL);
                    continue block6;
                }
                case DIGIT: {
                    if (digits < maxDigits) {
                        result.append(DIGIT_CHARS.charAt(this.getRandomNumberInRange(0, DIGIT_CHARS.length() - 1)));
                        ++digits;
                        continue block6;
                    }
                    --i;
                    types.remove((Object)CharType.DIGIT);
                    continue block6;
                }
                case UPPERCASE: {
                    if (uppercase < maxUppercase) {
                        result.append(UPPERCASE_CHARS.charAt(this.getRandomNumberInRange(0, UPPERCASE_CHARS.length() - 1)));
                        ++uppercase;
                        continue block6;
                    }
                    --i;
                    types.remove((Object)CharType.UPPERCASE);
                    continue block6;
                }
                case LOWERCASE: {
                    if (lowercase < maxLowercase) {
                        result.append(LOWERCASE_CHARS.charAt(this.getRandomNumberInRange(0, LOWERCASE_CHARS.length() - 1)));
                        ++lowercase;
                        continue block6;
                    }
                    --i;
                    types.remove((Object)CharType.LOWERCASE);
                }
            }
        }
        return result.toString();
    }

    private int getRandomNumberInRange(int min, int max) {
        return this.random.ints(min, max + 1).limit(1L).findFirst().getAsInt();
    }

    private static enum CharType {
        SPECIAL,
        DIGIT,
        UPPERCASE,
        LOWERCASE;

    }
}

