/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.lib.auth.PrincipalsResultMapper;
import com.enonic.xp.query.expr.ConstraintExpr;
import com.enonic.xp.query.expr.QueryExpr;
import com.enonic.xp.query.parser.QueryParser;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.SecurityService;
import com.enonic.xp.security.UserQuery;
import com.enonic.xp.security.UserQueryResult;
import java.util.List;
import java.util.function.Supplier;

public final class FindUsersHandler
implements ScriptBean {
    private Supplier<SecurityService> securityService;
    private int start = 0;
    private int count = 10;
    private String query;
    private String sort;
    private boolean includeProfile;

    public void setStart(Integer start) {
        if (start != null) {
            this.start = start;
        }
    }

    public void setCount(Integer count) {
        if (count != null) {
            this.count = count;
        }
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setIncludeProfile(boolean includeProfile) {
        this.includeProfile = includeProfile;
    }

    public PrincipalsResultMapper execute() {
        ConstraintExpr constraintExpr = QueryParser.parseCostraintExpression((String)(this.query == null ? "" : this.query));
        List orderExpressions = QueryParser.parseOrderExpressions((String)(this.sort == null ? "" : this.sort));
        QueryExpr queryExpr = QueryExpr.from((ConstraintExpr)constraintExpr, (Iterable)orderExpressions);
        UserQuery userQuery = UserQuery.create().from(this.start).size(this.count).queryExpr(queryExpr).build();
        UserQueryResult result = this.securityService.get().query(userQuery);
        return new PrincipalsResultMapper(result.getUsers(), result.getTotalSize(), this.includeProfile);
    }

    public void initialize(BeanContext context) {
        this.securityService = context.getService(SecurityService.class);
    }
}

