/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api.util;

import com.empyr.api.util.FileUpload;
import com.empyr.api.util.HttpRequestUtil;
import com.empyr.api.util.MethodType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsHttpRequestUtil
implements HttpRequestUtil {
    private static final transient Log log = LogFactory.getLog(CommonsHttpRequestUtil.class);
    private static MultiThreadedHttpConnectionManager connManager = new MultiThreadedHttpConnectionManager();
    private static HttpClient client;

    private HttpMethod createMethod(MethodType methodType, String endPoint, Map<String, Object> params) {
        GetMethod method = null;
        ArrayList<FilePart> fileParts = new ArrayList<FilePart>();
        ArrayList<StringPart> stringParts = new ArrayList<StringPart>();
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() instanceof String) {
                    pairs.add(new NameValuePair(entry.getKey(), (String)entry.getValue()));
                    stringParts.add(new StringPart(entry.getKey(), (String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof FileUpload) {
                    FileUpload fu = (FileUpload)entry.getValue();
                    FilePart fp = new FilePart("file", (PartSource)fu);
                    fp.setContentType(fu.getContentType());
                    fileParts.add(fp);
                    continue;
                }
                if (entry.getValue().getClass().isArray()) {
                    int length = Array.getLength(entry.getValue());
                    for (int i = 0; i < length; ++i) {
                        pairs.add(new NameValuePair(entry.getKey(), (String)Array.get(entry.getValue(), i)));
                        stringParts.add(new StringPart(entry.getKey(), (String)Array.get(entry.getValue(), i)));
                    }
                    continue;
                }
                throw new RuntimeException("Unrecognized type for post: " + entry.getValue().getClass().getName());
            }
        }
        switch (methodType) {
            case GET: {
                method = new GetMethod();
                break;
            }
            case DELETE: {
                method = new DeleteMethod();
                break;
            }
            case POST: {
                method = new PostMethod();
                break;
            }
            case PUT: {
                method = new PutMethod();
            }
        }
        try {
            method.setURI(new URI(endPoint, true));
        }
        catch (URIException e) {
            throw new RuntimeException(e);
        }
        if (method instanceof PostMethod) {
            if (fileParts.size() > 0) {
                ArrayList<Object> parts = new ArrayList<Object>();
                parts.addAll(fileParts);
                parts.addAll(stringParts);
                MultipartRequestEntity mre = new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams());
                ((PostMethod)method).setRequestEntity((RequestEntity)mre);
            } else {
                ((PostMethod)method).addParameters(pairs.toArray(new NameValuePair[0]));
            }
        } else {
            method.setQueryString(pairs.toArray(new NameValuePair[0]));
            String[] endPointParts = endPoint.split("\\?");
            if (endPointParts.length > 1) {
                String realQueryString = method.getQueryString() + "&" + endPointParts[1];
                method.setQueryString(realQueryString);
            }
        }
        method.setRequestHeader("Accept", "application/json");
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendRequest(HttpMethod method) throws IOException {
        String result = null;
        try {
            ArrayList<String> authPrefs = new ArrayList<String>(1);
            authPrefs.add("Basic");
            client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
            client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
            int statusCode = client.executeMethod(method);
            result = this.convertStreamToString(method.getResponseBodyAsStream());
            if (statusCode < 200 || statusCode > 299) {
                log.debug((Object)("Unexpected response: " + statusCode + "\n" + result));
            }
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    @Override
    public String executeMethod(MethodType type, String endPoint, Map<String, Object> params) {
        String result = null;
        HttpMethod method = this.createMethod(type, endPoint, params);
        try {
            result = this.sendRequest(method);
        }
        catch (Exception e) {
            log.warn((Object)("Exception caught executing client method: " + endPoint + " with params: " + params), (Throwable)e);
            throw new RuntimeException(e);
        }
        return result;
    }

    static {
        connManager.setMaxTotalConnections(10);
        connManager.setMaxConnectionsPerHost(5);
        client = new HttpClient((HttpConnectionManager)connManager);
    }
}

