/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api;

import com.empyr.api.ClientListener;
import com.empyr.api.Request;
import com.empyr.api.exceptions.LoginException;
import com.empyr.api.model.OAuthResponse;
import com.empyr.api.model.RestApplication;
import com.empyr.api.model.RestBusiness;
import com.empyr.api.model.RestCard;
import com.empyr.api.model.RestResponse;
import com.empyr.api.model.RestResults;
import com.empyr.api.model.RestTransaction;
import com.empyr.api.model.RestUser;
import com.empyr.api.util.CommonsHttpRequestUtil;
import com.empyr.api.util.FileUpload;
import com.empyr.api.util.HttpRequestUtil;
import com.empyr.api.util.JacksonRequestAdapter;
import com.empyr.api.util.MethodType;
import com.empyr.api.util.RequestAdapter;
import com.empyr.api.util.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmpyrClient {
    private static volatile EmpyrClient mainInstance = null;
    private static final String OAUTH_ENDPOINT = "/oauth/token";
    private static final String API_ENDPOINT = "/api/v2";
    private String host = "https://api.mogl.com";
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private String userToken;
    private int autoRetryTimes = -1;
    private HttpRequestUtil requestUtil = new CommonsHttpRequestUtil();
    private RequestAdapter requestAdapter = new JacksonRequestAdapter();
    private List<ClientListener> listeners = new ArrayList<ClientListener>();

    public EmpyrClient(String clientId) {
        this.clientId = clientId;
    }

    public EmpyrClient(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public void addListener(ClientListener cl) {
        this.listeners.add(cl);
    }

    public void removeListener(ClientListener cl) {
        this.listeners.remove(cl);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setAutoRetryTimes(int autoRetryTimes) {
        this.autoRetryTimes = autoRetryTimes;
    }

    public void setHost(String host) {
        this.host = host;
    }

    private String getOAuthEndpoint() {
        return this.host + OAUTH_ENDPOINT;
    }

    private String getApiEndpoint() {
        return this.host + API_ENDPOINT;
    }

    public static EmpyrClient getInstance() {
        if (mainInstance == null) {
            throw new RuntimeException("Empyr client instance should have been previously initialized through a getInstance call that had the client id.");
        }
        return mainInstance;
    }

    public static EmpyrClient getInstance(String clientId) {
        if (mainInstance == null) {
            mainInstance = new EmpyrClient(clientId);
        }
        return mainInstance;
    }

    public static EmpyrClient getInstance(String clientId, String clientSecret) {
        if (mainInstance == null) {
            mainInstance = new EmpyrClient(clientId, clientSecret);
        }
        return mainInstance;
    }

    public void identify(String userToken) {
        this.userToken = userToken;
    }

    public RestResponse<RestUser> usersSignup(String firstname, String lastname, String email, String postalCode, String password, String referralCode, Map<String, Object> additionalParams) {
        Request r = ((Request)((Request)Request.createRequest(MethodType.POST, "/users", true).addParams(new Object[]{"firstName", firstname, "lastName", lastname, "email", email, "address.postalCode", postalCode, "password", password, "userWhoInvited", referralCode})).addParams((Map)additionalParams)).expects("user", RestUser.class);
        return this.executeRequest(r);
    }

    public RestResponse<RestUser> usersGet(String userId) {
        Request r = Request.createRequest(MethodType.GET, "/users/" + userId).expects("user", RestUser.class);
        return this.executeRequest(r);
    }

    public RestResponse<RestUser> uploadPhoto(FileUpload fu) {
        Request r = ((Request)Request.createRequest(MethodType.POST, "/users/updatePhoto").addParams(new Object[]{"file", fu})).expects("user", RestUser.class);
        return this.executeRequest(r);
    }

    public RestResponse<RestUser> usersLookup(String email) {
        Request r = ((Request)Request.createRequest(MethodType.GET, "/users/lookup", true).addParams(new Object[]{"email", email})).expects("user", RestUser.class);
        return this.executeRequest(r);
    }

    public RestResponse<RestResults<RestTransaction>> usersGetTransactions(Integer userId, String userToken) {
        new AssertionError(userId != null);
        Request r = Request.createRequest(MethodType.GET, "/users/" + userId + "/transactions", true, userToken).expects("transactions", new TypeReference<RestResults<RestTransaction>>(){});
        return this.executeRequest(r);
    }

    public synchronized String usersLogin(String username, String password) {
        String endPoint = this.getOAuthEndpoint();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("client_id", this.clientId);
        params.put("client_secret", this.clientSecret);
        params.put("grant_type", "password");
        params.put("username", username);
        params.put("password", password);
        params.put("code", "token");
        String strResponse = this.requestUtil.executeMethod(MethodType.POST, endPoint, params);
        OAuthResponse or = this.requestAdapter.adapt(OAuthResponse.class, strResponse);
        if (or == null || or.access_token == null) {
            this.authorizationError(or.error_description);
            throw new LoginException(or.error_description);
        }
        this.accessToken = or.access_token;
        return this.accessToken;
    }

    public RestResponse<Map<String, String>> getTopCategories() {
        Request r = Request.createRequest(MethodType.GET, "/utilities/categories").expects("results", new TypeReference<Map<String, String>>(){});
        return this.executeRequest(r);
    }

    public RestResponse<Map<String, String>> getFeatures() {
        Request r = Request.createRequest(MethodType.GET, "/utilities/features").expects("results", new TypeReference<Map<String, String>>(){});
        return this.executeRequest(r);
    }

    public RestResponse<RestCard> cardsAdd(String cardNumber, int expirationMonth, int expirationYear, String userToken) {
        return this.cardsAdd(cardNumber, expirationMonth, expirationYear, userToken, null);
    }

    public RestResponse<RestCard> cardsAdd(String cardNumber, int expirationMonth, int expirationYear, String userToken, Map<String, Object> additionalParams) {
        Request r = ((Request)((Request)Request.createRequest(MethodType.POST, "/cards", true, userToken).addParams(new Object[]{"cardNumber", cardNumber, "expirationMonth", expirationMonth, "expirationYear", expirationYear})).addParams((Map)additionalParams)).expects("card", RestCard.class);
        return this.executeRequest(r);
    }

    public RestResponse<Boolean> cardsExists(String cardNumber) {
        new AssertionError(cardNumber != null);
        Request r = ((Request)Request.createRequest(MethodType.GET, "/cards/checkExists", true).addParams(new Object[]{"cardNumber", cardNumber})).expects("exists", Boolean.class);
        return this.executeRequest(r);
    }

    public RestResponse<RestResults<RestCard>> cardsList(String usertoken) {
        Request r = Request.createRequest(MethodType.GET, "/cards", true, usertoken).expects("cards", new TypeReference<RestResults<RestCard>>(){});
        return this.executeRequest(r);
    }

    public RestResponse<Boolean> cardsRemove(String cardNumber, String email) {
        new AssertionError(cardNumber != null);
        Request r = ((Request)Request.createRequest(MethodType.POST, "/cards/deleteByNumber", true, email).addParams(new Object[]{"cardNumber", cardNumber})).expects("removed", Boolean.class);
        return this.executeRequest(r);
    }

    public RestResponse<Map<String, String>> getCategories() {
        Request r = Request.createRequest(MethodType.GET, "/utilities/categories").expects("results", new TypeReference<Map<String, String>>(){});
        return this.executeRequest(r);
    }

    public RestResponse<RestApplication> getApplicationInfo() {
        Request r = Request.createRequest(MethodType.GET, "/utilities/info").expects("app", RestApplication.class);
        return this.executeRequest(r);
    }

    public RestResponse<RestBusiness> venuesSave(String businessToken, String name, String phone, Integer ownerId, String streetName, String postalCode, String category, String description, String merchantId, String amexId, String parent, Double discount, Double referralPercent) {
        Request r = ((Request)Request.createRequest(MethodType.POST, "/venues/add", true).addParams(new Object[]{"businessToken", businessToken, "name", name, "fullPhone", phone, "owner", ownerId, "address.streetName", streetName, "address.postalCode", postalCode, "category", category, "description", description, "merchantInfo.merchantId", merchantId, "merchantInfo.amexId", amexId, "parent", parent, "discount", discount, "referralPercent", referralPercent})).expects("venue", RestBusiness.class);
        return this.executeRequest(r);
    }

    public RestResponse<RestBusiness> venuesSave(String businessToken, String name, Integer ownerId, String streetName, String postalCode, String category, String description) {
        Request r = ((Request)Request.createRequest(MethodType.POST, "/venues/add", true).addParams(new Object[]{"businessToken", businessToken, "name", name, "owner", ownerId, "address.streetName", streetName, "address.postalCode", postalCode, "category", category, "description", description})).expects("venue", RestBusiness.class);
        return this.executeRequest(r);
    }

    public RestResponse<RestBusiness> venuesAddPhoto(String venueId, String type, FileUpload fu) {
        Request r = ((Request)Request.createRequest(MethodType.POST, "/venues/images/" + venueId + "/addPhoto").addParams(new Object[]{"file", fu, "type", type})).expects("venue", RestBusiness.class);
        return this.executeRequest(r);
    }

    public RestResponse<RestBusiness> venuesRemovePhoto(String venueId, Integer mediaId) {
        Request r = ((Request)Request.createRequest(MethodType.POST, "/venues/images/" + venueId + "/removePhoto").addParams(new Object[]{"media", mediaId})).expects("venue", RestBusiness.class);
        return this.executeRequest(r);
    }

    protected <T> RestResponse<T> executeRequest(Request<T> r) {
        return this.executeRequest(r, this.autoRetryTimes);
    }

    protected <T> RestResponse<T> executeRequest(Request<T> r, int numRetries) {
        if (this.accessToken != null) {
            r.addParams(new Object[]{"access_token", this.accessToken});
        }
        String endPoint = this.getApiEndpoint() + r.getEndPoint();
        endPoint = endPoint + (endPoint.contains("?") ? "&" : "?") + "client_id=" + this.clientId;
        try {
            String strResponse = this.requestUtil.executeMethod(r.getMethod(), endPoint, r.getRequestParams());
            this.requestAdapter.adapt(r, strResponse);
            RestResponse<T> response = r.getResponse();
            if (response.meta.code == 403 && r.isRequiresToken() && numRetries > 0) {
                this.refreshAccessToken();
                this.executeRequest(r, --numRetries);
            }
            if (response.meta.code == 403) {
                this.authorizationError(response.meta.error);
            } else if (response.meta.code >= 500 && response.meta.code <= 599) {
                this.unexpectedError(response.meta.error);
            } else if (response.meta.code >= 400) {
                this.validationError(response.meta.error, response.meta.errorDetails);
            }
        }
        catch (RuntimeException e) {
            if (e.getCause() != null) {
                this.connectionError(e.getCause().getMessage());
            } else {
                this.connectionError(e.getMessage());
            }
            throw e;
        }
        return r.getResponse();
    }

    private synchronized void refreshAccessToken() {
        OAuthResponse or = this.getAccessToken("client_credentials", new HashMap<String, Object>());
        if (or == null || or.access_token == null) {
            throw new RuntimeException("Unable to refresh token");
        }
        this.accessToken = or.access_token;
    }

    public synchronized OAuthResponse getAccessToken(String grantType, Map<String, Object> params) {
        OAuthResponse or = this.getAccessToken(this.clientId, this.clientSecret, grantType, params);
        return or;
    }

    protected synchronized OAuthResponse getAccessToken(String clientId, String clientSecret, String grantType, Map<String, Object> params) {
        String endPoint = this.getOAuthEndpoint();
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("grant_type", grantType);
        params.put("code", "token");
        String strResponse = this.requestUtil.executeMethod(MethodType.GET, endPoint, params);
        OAuthResponse or = this.requestAdapter.adapt(OAuthResponse.class, strResponse);
        return or;
    }

    private synchronized void authorizationError(String error_description) {
        for (ClientListener cl : this.listeners) {
            cl.authorizationError(error_description);
        }
    }

    private synchronized void connectionError(String error) {
        for (ClientListener cl : this.listeners) {
            cl.connectionError(error);
        }
    }

    private synchronized void validationError(String global, Map<String, String> errorDetails) {
        for (ClientListener cl : this.listeners) {
            cl.validationError(global, errorDetails);
        }
    }

    private synchronized void unexpectedError(String error) {
        for (ClientListener cl : this.listeners) {
            cl.unexpectedError(error);
        }
    }
}

