/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.partner.client;

import com.Ostermiller.util.CSVParse;
import com.Ostermiller.util.CSVPrint;
import com.Ostermiller.util.ExcelCSVParser;
import com.Ostermiller.util.ExcelCSVPrinter;
import com.Ostermiller.util.LabeledCSVParser;
import com.empyr.api.EmpyrClient;
import com.empyr.api.model.RestApplication;
import com.empyr.api.model.RestCard;
import com.empyr.api.model.RestResponse;
import com.empyr.api.model.RestUser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class CSVImportClient {
    @Option(name="-c", required=true, usage="Specifies the client id.")
    private String clientId;
    @Option(name="-s", required=true, usage="Specifies the client secret.")
    private String clientSecret;
    @Option(name="-f", required=true, usage="Specifies an input file.")
    private File inputFile;
    @Option(name="-e", required=true, usage="Specifies the error output file.")
    private File errorFile;
    @Option(name="-o", required=true, usage="Specifies the success output file.")
    private File successFile;
    @Option(name="-l", required=false, usage="Specifies what line of the input file to start at.")
    private int startLine = -1;
    @Option(name="-t", required=false, usage="Points the client at the mogl test server at test.mogl.com.")
    private boolean test = false;
    private int rowsProcessed = 0;

    private CSVPrint getPrinter(OutputStream out) {
        return new ExcelCSVPrinter(out);
    }

    private CSVParse getParser(InputStream in) {
        return new ExcelCSVParser(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(String clientId, String clientSecret, boolean testMode, InputStream in, OutputStream success, OutputStream error) throws IOException {
        try {
            CSVParse parser = this.getParser(in);
            CSVPrint successPrinter = this.getPrinter(success);
            CSVPrint errorPrinter = this.getPrinter(error);
            LabeledCSVParser input = new LabeledCSVParser(parser);
            EmpyrClient mogl = new EmpyrClient(clientId, clientSecret);
            mogl.setAutoRetryTimes(1);
            if (testMode) {
                mogl.setHost("https://test.mogl.com");
            }
            RestResponse<RestApplication> ra = mogl.getApplicationInfo();
            if (ra.meta.code != 200) {
                throw new RuntimeException("Failed to get application information. Aborting...");
            }
            int applicationId = ((RestApplication)ra.response).id;
            while (input.getLine() != null) {
                ArrayList<Card> cards;
                boolean skipCards;
                boolean skipSignup;
                boolean skipUser;
                String email;
                block28: {
                    String[] cardsStrings;
                    block27: {
                        email = input.getValueByLabel("email");
                        if (this.rowsProcessed < this.startLine) {
                            System.out.println("Skipping row... " + email);
                            ++this.rowsProcessed;
                            continue;
                        }
                        if (StringUtils.isEmpty((String)email)) {
                            throw new RuntimeException("Couldn't find a value for the email column this could be because you don't have a header row. Please check the input file.");
                        }
                        System.out.println(email);
                        skipUser = false;
                        skipSignup = false;
                        skipCards = false;
                        cards = new ArrayList<Card>();
                        String action = input.getValueByLabel("action");
                        if (StringUtils.isEmpty((String)action) || !action.equalsIgnoreCase("R")) break block27;
                        skipUser = true;
                        String cardData = input.getValueByLabel("cards");
                        cardData = cardData.split(" ")[0];
                        RestResponse<Boolean> removeResponse = mogl.cardsRemove(cardData, email);
                        if (removeResponse.meta.code == 200) break block28;
                        this.printError(errorPrinter, email, "Unexpected remove response: " + removeResponse);
                        break block28;
                    }
                    String cardsData = input.getValueByLabel("cards");
                    if (!StringUtils.isEmpty((String)cardsData) && (cardsStrings = cardsData.split("&")) != null && cardsStrings.length > 0) {
                        for (String card : cardsStrings) {
                            String[] cardParts = card.split("\\s");
                            cards.add(new Card(cardParts[0], cardParts[2], cardParts[1]));
                            RestResponse<Boolean> cardCheckResponse = mogl.cardsExists(cardParts[0]);
                            if (cardCheckResponse.meta.code != 200) {
                                skipUser = true;
                                this.printError(errorPrinter, email, "Unexpected card check response: " + cardCheckResponse);
                                break;
                            }
                            if (!((Boolean)cardCheckResponse.response).booleanValue()) continue;
                            skipUser = true;
                            this.printError(errorPrinter, email, "Card already registered: " + (this.rowsProcessed + 1));
                            break;
                        }
                    }
                }
                if (!skipUser) {
                    RestResponse<RestUser> userResponse = mogl.usersLookup(email);
                    if (userResponse.meta.code == 403) {
                        skipUser = true;
                        this.printError(errorPrinter, email, "User account has been disabled.");
                    } else if (userResponse.meta.code != 404) {
                        if (userResponse.meta.code != 200) {
                            throw new RuntimeException("Unexpected response received: " + userResponse);
                        }
                        if (((RestUser)userResponse.response).applicationId == null || applicationId != ((RestUser)userResponse.response).applicationId) {
                            skipUser = true;
                            this.printError(errorPrinter, email, "User's email already registered by another application");
                        } else {
                            skipSignup = true;
                        }
                    }
                }
                if (!skipUser) {
                    if (!skipSignup) {
                        String postalCode;
                        String referralCode;
                        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
                        additionalParams.put("sendWelcomeEmail", false);
                        String password = input.getValueByLabel("password");
                        if (StringUtils.isEmpty((String)password)) {
                            additionalParams.put("generatePassword", true);
                            password = null;
                        }
                        if (StringUtils.isEmpty((String)(referralCode = input.getValueByLabel("referralCode")))) {
                            referralCode = null;
                        }
                        if ((postalCode = input.getValueByLabel("postalcode")).matches("\\d{5}.*")) {
                            postalCode = postalCode.substring(0, 5);
                        }
                        RestResponse<RestUser> userResponse = mogl.usersSignup(input.getValueByLabel("firstname"), input.getValueByLabel("lastname"), email, postalCode, password, referralCode, additionalParams);
                        if (userResponse.meta.code != 200) {
                            this.printError(errorPrinter, email, "Got error signing up user: " + userResponse);
                            skipCards = true;
                        }
                    }
                    if (!skipCards) {
                        for (Card c : cards) {
                            RestResponse<RestCard> cardResponse = mogl.cardsAdd(c.number, c.expirationMonth, c.expirationYear, email);
                            if (cardResponse.meta.code == 200) continue;
                            this.printError(errorPrinter, email, "Error adding card: " + cardResponse);
                        }
                        this.printSuccess(successPrinter, email);
                    }
                }
                ++this.rowsProcessed;
                if (this.rowsProcessed % 100 != 0) continue;
                System.out.println("Processing... " + this.rowsProcessed);
            }
        }
        finally {
            in.close();
            success.close();
            error.close();
        }
    }

    public void doImport() throws Exception {
        FileInputStream in = new FileInputStream(this.inputFile);
        FileOutputStream sStream = new FileOutputStream(this.successFile);
        FileOutputStream eStream = new FileOutputStream(this.errorFile);
        this.doImport(this.clientId, this.clientSecret, this.test, in, sStream, eStream);
    }

    private void printSuccess(CSVPrint successPrinter, String email) {
        successPrinter.println(new String[]{email});
    }

    private void printError(CSVPrint errorPrinter, String email, String message) {
        errorPrinter.println(new String[]{email, message});
    }

    public static void main(String[] args) throws Exception {
        CSVImportClient importer = new CSVImportClient();
        CmdLineParser parser = new CmdLineParser((Object)importer);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
            System.exit(-1);
        }
        System.out.println("Starting MOGL Importer...");
        importer.doImport();
        System.out.printf("Finished import %d rows processed.", importer.rowsProcessed);
        System.exit(0);
    }

    public static class Card {
        public String number;
        public int expirationMonth;
        public int expirationYear;

        public Card(String number, String expirationMonth, String expirationYear) {
            this.number = number;
            this.expirationMonth = Integer.parseInt(expirationMonth);
            this.expirationYear = Integer.parseInt(expirationYear);
        }

        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this);
        }
    }
}

