/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api.util.adapters.ios;

import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class RestKitAdapter {
    private Reflections reflections;
    private static final String outputDir = "restkit2";
    private static final String clientHeaderBody = "#import <Foundation/Foundation.h>\n\n@interface _MOGLClient : NSObject\n\n@property (nonatomic, strong) NSMutableDictionary* objectMappings;\n\n@end";
    private static final String clientImplIntro = "#import \"_MOGLClient.h\"\n#import \"MOGLModel.h\"\n#import \"RestKit.h\"\n\n@implementation _MOGLClient\n\n-(_MOGLClient*)init\n{\n\t[self setObjectMappings:[[NSMutableDictionary alloc] init]];";
    private static final String clientImplTrailer = "\treturn self;\n}\n@end\n";
    private static Map<String, String> typeMappings = new HashMap<String, String>();
    private static Map<String, String> nameMappings = new HashMap<String, String>();
    private static Map<String, String> condensedMappings = new HashMap<String, String>();

    private PrintWriter getWriter(String filename) throws Exception {
        return new PrintWriter(new FileWriter(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adapt() throws Exception {
        LinkedList<ClassLoader> classLoadersList = new LinkedList<ClassLoader>();
        classLoadersList.add(ClasspathHelper.contextClassLoader());
        classLoadersList.add(ClasspathHelper.staticClassLoader());
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner(false), new ResourcesScanner()}).setUrls(ClasspathHelper.forClassLoader((ClassLoader[])classLoadersList.toArray(new ClassLoader[0]))).filterInputsBy((Predicate)new FilterBuilder().include(FilterBuilder.prefix((String)"com.mogl.api.v2.model"))));
        new File(outputDir).mkdirs();
        PrintWriter globalHeader = this.getWriter("restkit2/MOGLModel.h");
        PrintWriter clientHeader = this.getWriter("restkit2/_MOGLClient.h");
        PrintWriter clientImpl = this.getWriter("restkit2/_MOGLClient.m");
        try {
            HashSet<RKNullRelationship> relationships = new HashSet<RKNullRelationship>();
            globalHeader.println("#ifndef _MOGLHEADERS\n#define _MOGLHEADERS\n\n");
            clientHeader.println(clientHeaderBody);
            clientImpl.println(clientImplIntro);
            for (Class clazz : this.reflections.getSubTypesOf(Object.class)) {
                System.out.println(clazz.getName());
                String name = clazz.getSimpleName();
                if (condensedMappings.containsKey(name)) continue;
                PrintWriter header = this.getWriter("restkit2/" + name + ".h");
                PrintWriter impl = this.getWriter("restkit2/" + name + ".m");
                try {
                    globalHeader.println("#import \"" + name + ".h\"");
                    header.println("#import <Foundation/Foundation.h>");
                    impl.printf("#import \"%s.h\"\n\n@implementation %s\n@end", name, name);
                    clientImpl.printf("\t{\n\t\tRKObjectMapping *mapping = [RKObjectMapping mappingForClass:[%s class]];\n\t\t[mapping addAttributeMappingsFromDictionary: @{\n", name);
                    StringWriter propsStr = new StringWriter();
                    PrintWriter props = new PrintWriter(propsStr);
                    for (Field f : this.buildFields(clazz)) {
                        String propertyName;
                        String simpleType = f.getType().getSimpleName();
                        String mappedName = propertyName = f.getName();
                        System.out.printf("\t%-30.30s  %-30.60s%n", propertyName, simpleType);
                        if (nameMappings.containsKey(propertyName)) {
                            mappedName = nameMappings.get(propertyName);
                        }
                        String mappedType = typeMappings.get(simpleType);
                        if (f.getType().isArray()) {
                            mappedType = "NSArray";
                        }
                        if (simpleType.equals("Object")) {
                            simpleType = "id";
                        }
                        RKRelationship r = null;
                        if (mappedType != null) {
                            if (mappedType.equals("BOOL")) {
                                props.printf("\t@property (nonatomic) BOOL %s;\n", mappedName);
                            } else {
                                String genericClassName;
                                props.printf("\t@property (nonatomic, copy) %s* %s; // standard\n", mappedType, mappedName);
                                boolean dictionary = false;
                                Type genericType = f.getGenericType();
                                if (mappedType.equals("NSDictionary")) {
                                    genericType = ((ParameterizedType)genericType).getActualTypeArguments()[1];
                                    dictionary = true;
                                }
                                if (genericType instanceof ParameterizedType) {
                                    ParameterizedType paramType = (ParameterizedType)genericType;
                                    genericType = paramType.getActualTypeArguments()[0];
                                }
                                if ((genericClassName = genericType.getTypeName()).contains("$")) {
                                    genericClassName = StringUtils.substringAfterLast((String)genericClassName, (String)"$");
                                }
                                if (genericClassName.contains(".")) {
                                    genericClassName = StringUtils.substringAfterLast((String)genericClassName, (String)".");
                                }
                                if (genericClassName.contains("[")) {
                                    genericClassName = StringUtils.substringBeforeLast((String)genericClassName, (String)"[");
                                }
                                if (condensedMappings.containsKey(genericClassName)) {
                                    genericClassName = condensedMappings.get(genericClassName);
                                }
                                if (genericClassName.equals("T")) {
                                    r = new RKNullRelationship();
                                }
                                if (genericClassName.startsWith("Rest")) {
                                    r = dictionary ? new RKDictionaryRelationship(name, propertyName, mappedName, genericClassName) : new RKRelationship(name, propertyName, mappedName, genericClassName);
                                }
                            }
                        } else if (simpleType.equals("id")) {
                            props.printf("\t@property (nonatomic, strong) %s %s; //id mapping\n", simpleType, mappedName);
                            r = new RKNullRelationship();
                        } else if (simpleType.startsWith("Rest")) {
                            if (condensedMappings.containsKey(simpleType)) {
                                simpleType = condensedMappings.get(simpleType);
                            }
                            header.printf("@class %s;\n", simpleType);
                            props.printf("\t@property (nonatomic, strong) %s* %s;\n", simpleType, mappedName);
                            r = new RKRelationship(name, propertyName, mappedName, simpleType);
                        } else {
                            throw new RuntimeException("Couldn't map type: " + simpleType);
                        }
                        if (r != null) {
                            relationships.add((RKNullRelationship)r);
                            continue;
                        }
                        clientImpl.printf("\t\t\t@\"%s\" : @\"%s\",\n", propertyName, mappedName);
                    }
                    clientImpl.printf("\t\t}];\n\t\t[[self objectMappings] setObject:mapping forKey:(id<NSCopying>)[%s class]];\n\t}\n", name);
                    header.println("\n@interface " + name + " : NSObject");
                    header.print(propsStr.toString());
                    header.println("@end");
                }
                finally {
                    header.close();
                    impl.close();
                }
            }
            globalHeader.println("#endif // _MOGLHEADERS");
            for (RKRelationship rKRelationship : relationships) {
                rKRelationship.printMapping(clientImpl);
            }
            clientImpl.println(clientImplTrailer);
        }
        finally {
            globalHeader.close();
            clientHeader.close();
            clientImpl.close();
        }
    }

    private <T> Set<Field> buildFields(Class<T> c) {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(c.getFields()));
        for (Class sub : this.reflections.getSubTypesOf(c)) {
            fields.addAll(this.buildFields(sub));
        }
        return fields;
    }

    public static void main(String[] args) throws Exception {
        RestKitAdapter rka = new RestKitAdapter();
        rka.adapt();
    }

    static {
        typeMappings.put("int", "NSNumber");
        typeMappings.put("double", "NSNumber");
        typeMappings.put("float", "NSNumber");
        typeMappings.put("Float", "NSNumber");
        typeMappings.put("String", "NSString");
        typeMappings.put("boolean", "BOOL");
        typeMappings.put("Boolean", "BOOL");
        typeMappings.put("Integer", "NSNumber");
        typeMappings.put("Double", "NSNumber");
        typeMappings.put("long", "NSNumber");
        typeMappings.put("Long", "NSNumber");
        typeMappings.put("Collection", "NSArray");
        typeMappings.put("List", "NSArray");
        typeMappings.put("Set", "NSSet");
        typeMappings.put("Map", "NSDictionary");
        typeMappings.put("Date", "NSDate");
        typeMappings.put("RestUrl", "NSString");
        typeMappings.put("CardType", "NSString");
        typeMappings.put("CardState", "NSString");
        typeMappings.put("AlertType", "NSString");
        typeMappings.put("PrivacyLevel", "NSString");
        typeMappings.put("FriendState", "NSString");
        typeMappings.put("DeviceType", "NSString");
        typeMappings.put("UpgradeActionType", "NSString");
        typeMappings.put("EventType", "NSString");
        typeMappings.put("Processor", "NSString");
        typeMappings.put("OfferRewardType", "NSString");
        typeMappings.put("OfferScheduleType", "NSString");
        typeMappings.put("OfferInterval", "NSString");
        typeMappings.put("RedeemState", "NSString");
        typeMappings.put("RestUrl", "NSString");
        typeMappings.put("T", "id");
        nameMappings.put("description", "descriptionText");
        condensedMappings.put("RestFullBusiness", "RestBusiness");
        condensedMappings.put("RestCompactBusiness", "RestBusiness");
        condensedMappings.put("RestCompactUser", "RestUser");
        condensedMappings.put("RestBase", "");
        condensedMappings.put("RestUrl", "");
    }

    public static class RKDictionaryRelationship
    extends RKRelationship {
        public RKDictionaryRelationship(String srcType, String srcProperty, String dstProperty, String dstType) {
            super(srcType, srcProperty, dstProperty, dstType);
        }

        @Override
        public void printMapping(PrintWriter p) {
            p.printf("\t{\n\t\tRKDynamicMapping* mapping = [RKDynamicMapping new];\n\t\t\n\t\t[mapping setObjectMappingForRepresentationBlock:^RKObjectMapping *(id representation) {\n\t\t\tNSDictionary *dict = representation;\n\t\t\tNSArray *keys = [dict allKeys];\n\t\t\tRKObjectMapping *dataMapping = [RKObjectMapping mappingForClass:[NSMutableDictionary class]];\n\t\t\tfor( NSString* key in keys )\n\t\t\t{\n\t\t\t\t[dataMapping addRelationshipMappingWithSourceKeyPath:key mapping:[[self objectMappings] objectForKey:[%s class]]];\n\t\t\t}\n\t\t\treturn dataMapping;\n\t\t}];\n\t\t\n\t\t[[[self objectMappings] objectForKey:[%s class]] addPropertyMapping:[RKRelationshipMapping\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   relationshipMappingFromKeyPath:@\"%s\"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   toKeyPath:@\"%s\"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   withMapping:mapping\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   ]];\n\t}\n", this.dstType, this.srcType, this.srcProperty, this.dstProperty);
        }
    }

    public static class RKNullRelationship
    extends RKRelationship {
        public RKNullRelationship() {
            super(null, null, null, null);
        }

        @Override
        public void printMapping(PrintWriter p) {
        }
    }

    public static class RKRelationship {
        public String srcType;
        public String srcProperty;
        public String dstProperty;
        public String dstType;

        public RKRelationship(String srcType, String srcProperty, String dstProperty, String dstType) {
            this.srcType = srcType;
            this.srcProperty = srcProperty;
            this.dstProperty = dstProperty;
            this.dstType = dstType;
        }

        public void printMapping(PrintWriter p) {
            p.printf("\t[[[self objectMappings] objectForKey:[%s class]] addPropertyMapping:[RKRelationshipMapping\n", this.srcType);
            p.printf("\t\t\t\trelationshipMappingFromKeyPath:@\"%s\"\n", this.srcProperty);
            p.printf("\t\t\t\ttoKeyPath:@\"%s\"\n", this.dstProperty);
            p.printf("\t\t\t\twithMapping:[[self objectMappings] objectForKey:[%s class]]\n", this.dstType);
            p.printf("\t]];\n\n", new Object[0]);
        }
    }
}

