/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api.model;

import com.empyr.api.annotations.ApiField;
import com.empyr.api.annotations.Documented;
import com.empyr.api.model.RestBase;
import com.empyr.api.model.RestCompactUser;

@Documented(name="card", description="Represents a user's credit card.")
public class RestCard
extends RestBase {
    @ApiField(value="The id of the card.")
    public Integer id;
    @ApiField(value="The last 4 of the credit card.")
    public String last4;
    @ApiField(value="A valid expiration month 1 to 12")
    public Integer expirationMonth;
    @ApiField(value="A valid expiration year")
    public Integer expirationYear;
    @ApiField(value="Whether this is the card the user will be payed back on.")
    public boolean primary;
    @ApiField(value="Indicates the current status of the card.")
    public CardState cardState;
    @ApiField(value="Synchronization state.")
    public boolean synchronizationState;
    @ApiField(value="The type of the credit card.")
    public CardType cardType;
    @ApiField(value="The user who owns the card. Only populated CARD_ADD/CARD_REMOVE webhook events.")
    public RestCompactUser user;

    public static enum CardType {
        VISA,
        MASTERCARD,
        AMERICAN_EXPRESS,
        DISCOVER,
        ENROUTE,
        JCB,
        DINERS_CLUB,
        AMERICAN_DINERS,
        CARTE_BLANCHE;

    }

    public static enum CardState {
        ACTIVE,
        INACTIVE,
        ERROR;

    }
}

