/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api;

import com.empyr.api.util.FileUpload;
import com.empyr.api.util.MethodType;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private MethodType method;
    private String endPoint;
    private Map<String, Object> requestParams = new HashMap<String, Object>();

    public HttpRequest(MethodType method, String endPoint) {
        this.method = method;
        this.endPoint = endPoint;
    }

    public static HttpRequest createHttpRequest(MethodType get, String endpoint) {
        return new HttpRequest(get, endpoint);
    }

    public HttpRequest addParams(Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return this;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            Object value = entry.getValue();
            if (!(value instanceof FileUpload) && !value.getClass().isArray()) {
                value = String.valueOf(value);
            }
            this.requestParams.put(entry.getKey(), value);
        }
        return this;
    }

    public HttpRequest addParams(Object ... params) {
        if (params == null || params.length <= 0) {
            return this;
        }
        if (params.length % 2 != 0) {
            throw new RuntimeException("Uneven param keys to values.");
        }
        for (int i = 0; i < params.length; i += 2) {
            if (params[i + 1] == null) continue;
            Object value = params[i + 1];
            if (!(value instanceof FileUpload) && !value.getClass().isArray()) {
                value = String.valueOf(value);
            }
            this.requestParams.put(String.valueOf(params[i]), value);
        }
        return this;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public Map<String, Object> getRequestParams() {
        return this.requestParams;
    }
}

