/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.observability.observation;

import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.observability.annotation.Tracked;
import com.embabel.agent.observability.observation.EmbabelObservationContext;
import com.embabel.agent.observability.observation.ObservationUtils;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.Arrays;
import java.util.StringJoiner;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class TrackedAspect {
    private static final Logger log = LoggerFactory.getLogger(TrackedAspect.class);
    private final ObservationRegistry registry;
    private final int maxAttributeLength;

    public TrackedAspect(ObservationRegistry registry, int maxAttributeLength) {
        this.registry = registry;
        this.maxAttributeLength = maxAttributeLength;
    }

    @Around(value="@annotation(tracked)")
    public Object tracked(ProceedingJoinPoint joinPoint, Tracked tracked) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String operationName = tracked.value().isEmpty() ? signature.getMethod().getName() : tracked.value();
        String runId = "";
        AgentProcess process = AgentProcess.get();
        if (process != null) {
            runId = process.getId();
        }
        EmbabelObservationContext context = EmbabelObservationContext.custom(runId, operationName);
        Observation observation = Observation.createNotStarted((String)operationName, () -> context, (ObservationRegistry)this.registry);
        observation.lowCardinalityKeyValue("embabel.tracked.type", tracked.type().name());
        observation.lowCardinalityKeyValue("embabel.tracked.class", signature.getDeclaringType().getSimpleName());
        if (!tracked.description().isEmpty()) {
            observation.lowCardinalityKeyValue("embabel.tracked.description", tracked.description());
        }
        if (process != null) {
            observation.lowCardinalityKeyValue("embabel.tracked.agent", process.getAgent().getName());
        }
        String argsString = this.truncate(this.formatArgs(signature.getParameterNames(), joinPoint.getArgs()));
        observation.highCardinalityKeyValue("embabel.tracked.args", argsString);
        observation.start();
        Observation.Scope scope = observation.openScope();
        try {
            Object result = joinPoint.proceed();
            if (result != null) {
                observation.highCardinalityKeyValue("embabel.tracked.result", this.truncate(result.toString()));
            }
            Object object = result;
            return object;
        }
        catch (Throwable t) {
            observation.error(t);
            throw t;
        }
        finally {
            scope.close();
            observation.stop();
        }
    }

    private String formatArgs(String[] paramNames, Object[] args) {
        if (paramNames == null || paramNames.length != args.length) {
            return Arrays.toString(args);
        }
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        for (int i = 0; i < paramNames.length; ++i) {
            joiner.add(paramNames[i] + "=" + String.valueOf(args[i]));
        }
        return joiner.toString();
    }

    private String truncate(String value) {
        return ObservationUtils.truncate(value, this.maxAttributeLength);
    }
}

