/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.observability.observation;

import com.embabel.agent.observability.observation.EmbabelObservationContext;
import io.micrometer.common.KeyValue;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationView;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbabelTracingObservationHandler
implements TracingObservationHandler<EmbabelObservationContext> {
    private static final Logger log = LoggerFactory.getLogger(EmbabelTracingObservationHandler.class);
    private final Tracer tracer;
    private final Map<String, Span> activeAgentSpans = new ConcurrentHashMap<String, Span>();
    private final Map<String, Span> activeActionSpans = new ConcurrentHashMap<String, Span>();
    private final Map<String, Span> activeLlmSpans = new ConcurrentHashMap<String, Span>();
    private final Map<String, Span> activeToolLoopSpans = new ConcurrentHashMap<String, Span>();
    private final Map<Integer, Tracer.SpanInScope> activeScopes = new ConcurrentHashMap<Integer, Tracer.SpanInScope>();

    public EmbabelTracingObservationHandler(Tracer tracer) {
        this.tracer = tracer;
        log.info("EmbabelTracingObservationHandler initialized");
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof EmbabelObservationContext;
    }

    public void onStart(EmbabelObservationContext context) {
        Span span;
        if (context.isRoot()) {
            Span currentSpan = this.tracer.currentSpan();
            if (currentSpan != null) {
                span = this.tracer.nextSpan(currentSpan).name(context.getName());
                span.start();
                log.debug("Created agent span as child of existing trace for: {} (runId: {})", (Object)context.getName(), (Object)context.getRunId());
            } else {
                span = this.createRootSpan(context.getName());
                log.debug("Created root span for agent: {} (runId: {})", (Object)context.getName(), (Object)context.getRunId());
            }
        } else {
            Span parentSpan = this.resolveParentSpan(context);
            if (parentSpan != null) {
                span = this.tracer.nextSpan(parentSpan).name(context.getName());
            } else {
                log.warn("No parent span found for {} '{}' (runId: {}), span will use thread-local context. Active maps: agents={}, actions={}, llms={}, toolLoops={}", new Object[]{context.getEventType(), context.getName(), context.getRunId(), this.activeAgentSpans.keySet(), this.activeActionSpans.keySet(), this.activeLlmSpans.keySet(), this.activeToolLoopSpans.keySet()});
                span = this.tracer.nextSpan().name(context.getName());
            }
            span.start();
            log.debug("Created child span for {}: {} (runId: {})", new Object[]{context.getEventType(), context.getName(), context.getRunId()});
        }
        span.tag("embabel.event.type", context.getEventType().name().toLowerCase());
        span.tag("embabel.run_id", context.getRunId());
        this.getTracingContext(context).setSpan(span);
        this.trackActiveSpan(context, span);
    }

    public void onScopeOpened(EmbabelObservationContext context) {
        Span span = this.getTracingContext(context).getSpan();
        if (span != null) {
            Tracer.SpanInScope scope = this.tracer.withSpan(span);
            this.activeScopes.put(System.identityHashCode((Object)context), scope);
        }
    }

    public void onScopeClosed(EmbabelObservationContext context) {
        Tracer.SpanInScope scope = this.activeScopes.remove(System.identityHashCode((Object)context));
        if (scope != null) {
            scope.close();
        }
    }

    public void onStop(EmbabelObservationContext context) {
        Throwable error;
        Span span = this.getRequiredSpan(context);
        for (KeyValue keyValue : context.getLowCardinalityKeyValues()) {
            span.tag(keyValue.getKey(), keyValue.getValue());
        }
        for (KeyValue keyValue : context.getHighCardinalityKeyValues()) {
            span.tag(keyValue.getKey(), keyValue.getValue());
        }
        if (context.getContextualName() != null) {
            span.name(context.getContextualName());
        }
        if ((error = context.getError()) != null) {
            span.error(error);
        }
        this.untrackActiveSpan(context);
        span.end();
        log.debug("Ended span for {}: {} (runId: {})", new Object[]{context.getEventType(), context.getName(), context.getRunId()});
    }

    public void onError(EmbabelObservationContext context) {
        Span span;
        Throwable error = context.getError();
        if (error != null && (span = this.getTracingContext(context).getSpan()) != null) {
            span.error(error);
        }
    }

    private Span createRootSpan(String name) {
        Span rootSpan;
        try (Tracer.SpanInScope ignored = this.tracer.withSpan(null);){
            rootSpan = this.tracer.nextSpan().name(name);
            rootSpan.start();
        }
        return rootSpan;
    }

    private Span resolveParentSpan(EmbabelObservationContext context) {
        Observation.Context parentCtx;
        TracingObservationHandler.TracingContext parentTracingCtx;
        Observation.ContextView contextView;
        ObservationView parentObs = context.getParentObservation();
        if (parentObs != null && (contextView = parentObs.getContextView()) instanceof Observation.Context && (parentTracingCtx = (TracingObservationHandler.TracingContext)(parentCtx = (Observation.Context)contextView).get(TracingObservationHandler.TracingContext.class)) != null && parentTracingCtx.getSpan() != null) {
            log.debug("Parent span resolved from parentObservation for {} '{}' (runId: {})", new Object[]{context.getEventType(), context.getName(), context.getRunId()});
            return parentTracingCtx.getSpan();
        }
        String runId = context.getRunId();
        switch (context.getEventType()) {
            case ACTION: {
                return this.activeAgentSpans.get(runId);
            }
            case AGENT_PROCESS: {
                if (context.getParentRunId() != null) {
                    Span parentActionSpan = this.activeActionSpans.get(context.getParentRunId());
                    if (parentActionSpan != null) {
                        return parentActionSpan;
                    }
                    return this.activeAgentSpans.get(context.getParentRunId());
                }
                return null;
            }
            case LLM_CALL: {
                Span llmActionSpan = this.activeActionSpans.get(runId);
                if (llmActionSpan != null) {
                    return llmActionSpan;
                }
                return this.activeAgentSpans.get(runId);
            }
            case TOOL_LOOP: {
                Span currentToolLoopSpan = this.tracer.currentSpan();
                if (currentToolLoopSpan != null) {
                    log.debug("TOOL_LOOP parent resolved to tracer.currentSpan() (runId: {})", (Object)runId);
                    return currentToolLoopSpan;
                }
                Span toolLoopActionSpan = this.activeActionSpans.get(runId);
                if (toolLoopActionSpan != null) {
                    log.debug("TOOL_LOOP parent resolved to ACTION span (runId: {}, no currentSpan)", (Object)runId);
                    return toolLoopActionSpan;
                }
                log.debug("TOOL_LOOP parent resolved to AGENT span (runId: {}, no currentSpan or ACTION)", (Object)runId);
                return this.activeAgentSpans.get(runId);
            }
            case TOOL_CALL: {
                Span currentSpan = this.tracer.currentSpan();
                if (currentSpan != null) {
                    return currentSpan;
                }
                Span toolActionSpan = this.activeActionSpans.get(runId);
                if (toolActionSpan != null) {
                    return toolActionSpan;
                }
                return this.activeAgentSpans.get(runId);
            }
            case GOAL: 
            case PLANNING: 
            case STATE_TRANSITION: 
            case LIFECYCLE: 
            case CUSTOM: {
                Span actionSpan = this.activeActionSpans.get(runId);
                if (actionSpan != null) {
                    return actionSpan;
                }
                return this.activeAgentSpans.get(runId);
            }
        }
        return null;
    }

    private void trackActiveSpan(EmbabelObservationContext context, Span span) {
        switch (context.getEventType()) {
            case AGENT_PROCESS: {
                this.activeAgentSpans.put(context.getRunId(), span);
                break;
            }
            case ACTION: {
                this.activeActionSpans.put(context.getRunId(), span);
                break;
            }
            case LLM_CALL: {
                this.activeLlmSpans.put(String.valueOf(System.identityHashCode((Object)context)), span);
                break;
            }
            case TOOL_LOOP: {
                this.activeToolLoopSpans.put(String.valueOf(System.identityHashCode((Object)context)), span);
                break;
            }
        }
    }

    private void untrackActiveSpan(EmbabelObservationContext context) {
        switch (context.getEventType()) {
            case AGENT_PROCESS: {
                this.activeAgentSpans.remove(context.getRunId());
                break;
            }
            case ACTION: {
                this.activeActionSpans.remove(context.getRunId());
                break;
            }
            case LLM_CALL: {
                this.activeLlmSpans.remove(String.valueOf(System.identityHashCode((Object)context)));
                break;
            }
            case TOOL_LOOP: {
                this.activeToolLoopSpans.remove(String.valueOf(System.identityHashCode((Object)context)));
                break;
            }
        }
    }
}

