/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.observability.observation;

import io.micrometer.observation.Observation;

public class EmbabelObservationContext
extends Observation.Context {
    private final boolean root;
    private final String runId;
    private final EventType eventType;
    private final String parentRunId;

    public EmbabelObservationContext(boolean root, String runId, String name, EventType eventType, String parentRunId) {
        this.root = root;
        this.runId = runId;
        this.eventType = eventType;
        this.parentRunId = parentRunId;
        this.setName(name);
    }

    public static EmbabelObservationContext rootAgent(String runId, String agentName) {
        return new EmbabelObservationContext(true, runId, agentName, EventType.AGENT_PROCESS, null);
    }

    public static EmbabelObservationContext subAgent(String runId, String agentName, String parentRunId) {
        return new EmbabelObservationContext(false, runId, agentName, EventType.AGENT_PROCESS, parentRunId);
    }

    public static EmbabelObservationContext action(String runId, String actionName) {
        return new EmbabelObservationContext(false, runId, actionName, EventType.ACTION, null);
    }

    public static EmbabelObservationContext goal(String runId, String goalName) {
        return new EmbabelObservationContext(false, runId, goalName, EventType.GOAL, null);
    }

    public static EmbabelObservationContext toolCall(String runId, String toolName) {
        return new EmbabelObservationContext(false, runId, toolName, EventType.TOOL_CALL, null);
    }

    public static EmbabelObservationContext planning(String runId, String planningName) {
        return new EmbabelObservationContext(false, runId, planningName, EventType.PLANNING, null);
    }

    public static EmbabelObservationContext stateTransition(String runId, String stateName) {
        return new EmbabelObservationContext(false, runId, stateName, EventType.STATE_TRANSITION, null);
    }

    public static EmbabelObservationContext lifecycle(String runId, String lifecycleState) {
        return new EmbabelObservationContext(false, runId, lifecycleState, EventType.LIFECYCLE, null);
    }

    public static EmbabelObservationContext llmCall(String runId, String llmName) {
        return new EmbabelObservationContext(false, runId, llmName, EventType.LLM_CALL, null);
    }

    public static EmbabelObservationContext toolLoop(String runId, String toolLoopName) {
        return new EmbabelObservationContext(false, runId, toolLoopName, EventType.TOOL_LOOP, null);
    }

    public static EmbabelObservationContext ranking(String rankingName) {
        return new EmbabelObservationContext(false, "", rankingName, EventType.RANKING, null);
    }

    public static EmbabelObservationContext dynamicAgentCreation(String agentName) {
        return new EmbabelObservationContext(false, "", agentName, EventType.DYNAMIC_AGENT_CREATION, null);
    }

    public static EmbabelObservationContext rag(String runId, String ragName) {
        return new EmbabelObservationContext(false, runId, ragName, EventType.RAG, null);
    }

    public static EmbabelObservationContext custom(String runId, String name) {
        return new EmbabelObservationContext(false, runId, name, EventType.CUSTOM, null);
    }

    public boolean isRoot() {
        return this.root;
    }

    public String getRunId() {
        return this.runId;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getParentRunId() {
        return this.parentRunId;
    }

    public static enum EventType {
        AGENT_PROCESS,
        ACTION,
        GOAL,
        TOOL_CALL,
        PLANNING,
        STATE_TRANSITION,
        LIFECYCLE,
        LLM_CALL,
        TOOL_LOOP,
        RAG,
        RANKING,
        DYNAMIC_AGENT_CREATION,
        CUSTOM;

    }
}

